% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobqueue_class.r
\name{jobqueue_class}
\alias{jobqueue_class}
\title{Assigns Jobs to Workers (R6 Class)}
\description{
Jobs go in. Results come out.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{hooks}}{A named list of currently registered callback hooks.}

\item{\code{jobs}}{Get or set - List of \link[=job_class]{jobs} currently managed by this
\code{\link[=jobqueue_class]{jobqueue}}.}

\item{\code{state}}{The \code{\link[=jobqueue_class]{jobqueue's}} state: \code{'starting'}, \code{'idle'},
\code{'busy'}, \code{'stopped'}, or \code{'error.'}}

\item{\code{uid}}{A short string, e.g. \code{'Q1'}, that uniquely identifies this
\code{\link[=jobqueue_class]{jobqueue}}.}

\item{\code{tmp}}{The \code{\link[=jobqueue_class]{jobqueue}}'s temporary directory.}

\item{\code{workers}}{Get or set - List of \code{\link[=worker_class]{workers}} used for processing
\code{\link[=job_class]{jobs}}.}

\item{\code{cnd}}{The error that caused the \code{\link[=jobqueue_class]{jobqueue}} to stop.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-jobqueue-new}{\code{jobqueue_class$new()}}
\item \href{#method-jobqueue-print}{\code{jobqueue_class$print()}}
\item \href{#method-jobqueue-run}{\code{jobqueue_class$run()}}
\item \href{#method-jobqueue-submit}{\code{jobqueue_class$submit()}}
\item \href{#method-jobqueue-wait}{\code{jobqueue_class$wait()}}
\item \href{#method-jobqueue-on}{\code{jobqueue_class$on()}}
\item \href{#method-jobqueue-stop}{\code{jobqueue_class$stop()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-new"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-new}{}}}
\subsection{Method \code{new()}}{
Creates a pool of background processes for handling \verb{$run()} and
\verb{$submit()} calls. These \code{\link[=worker_class]{workers}} are initialized
according to the \code{globals}, \code{packages}, and \code{init} arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$new(
  globals = NULL,
  packages = NULL,
  namespace = NULL,
  init = NULL,
  max_cpus = availableCores(),
  workers = ceiling(max_cpus * 1.2),
  timeout = NULL,
  hooks = NULL,
  reformat = NULL,
  signal = FALSE,
  cpus = 1L,
  stop_id = NULL,
  copy_id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{globals}}{A named list of variables that all \verb{<job>$expr}s will have
access to. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.}

\item{\code{packages}}{Character vector of package names to load on
\code{\link[=worker_class]{workers}}.}

\item{\code{namespace}}{The name of a package to attach to the
\code{\link[=worker_class]{worker's}} environment.}

\item{\code{init}}{A call or R expression wrapped in curly braces to evaluate on
each \code{\link[=worker_class]{worker}} just once, immediately after start-up.
Will have access to variables defined by \code{globals} and assets from
\code{packages} and \code{namespace}. Returned value is ignored.}

\item{\code{max_cpus}}{Total number of CPU cores that can be reserved by all
running \code{\link[=job_class]{jobs}} (\verb{sum(<job>$cpus)}). Does not enforce
limits on actual CPU utilization.}

\item{\code{workers}}{How many background \code{\link[=worker_class]{worker}} processes to
start. Set to more than \code{max_cpus} to enable standby
\code{\link[=worker_class]{workers}} to quickly swap out with
\code{\link[=worker_class]{workers}} that need to restart.}

\item{\code{timeout, hooks, reformat, signal, cpus, stop_id, copy_id}}{Defaults for this \code{\link[=jobqueue_class]{jobqueue's}} \verb{$run()} method.
Here only, \code{stop_id} and \code{copy_id} must be either a
\verb{function (job)} or \code{NULL}. \code{hooks} can set
\code{\link[=jobqueue_class]{jobqueue}}, \code{\link[=worker_class]{worker}}, and/or
\code{\link[=job_class]{job}} hooks - see the "Attaching" section in
\code{vignette('hooks')}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link[=jobqueue_class]{jobqueue}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-print"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-print}{}}}
\subsection{Method \code{print()}}{
Print method for a \code{\link[=jobqueue_class]{jobqueue}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments are not used currently.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-run"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-run}{}}}
\subsection{Method \code{run()}}{
Creates a \code{\link[=job_class]{job}} object and submits it to the
\code{\link[=jobqueue_class]{jobqueue}} for running. Any \code{NA} arguments will be
replaced with their value from \code{jobqueue_class$new()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$run(
  expr,
  vars = list(),
  timeout = NA,
  hooks = NA,
  reformat = NA,
  signal = NA,
  cpus = NA,
  stop_id = NA,
  copy_id = NA,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{A call or R expression wrapped in curly braces to evaluate on a
\code{\link[=worker_class]{worker}}. Will have access to any variables defined
by \code{vars}, as well as the \code{\link[=jobqueue_class]{jobqueue's}} \code{globals},
\code{packages}, and \code{init} configuration. See \code{vignette('eval')}.}

\item{\code{vars}}{A named list of variables to make available to \code{expr} during
evaluation. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.
Or a \verb{function (job)} that returns such an object.}

\item{\code{timeout}}{A named numeric vector indicating the maximum number of
seconds allowed for each state the \code{\link[=job_class]{job}} passes through,
or 'total' to apply a single timeout from 'submitted' to 'done'. Can
also limit the 'starting' state for \code{\link[=worker_class]{workers}}. A
\verb{function (job)} can be used in place of a number.
Example: \code{timeout = c(total = 2.5, running = 1)}.
See \code{vignette('stops')}.}

\item{\code{hooks}}{A named list of functions to run when the \code{\link[=job_class]{job}}
state changes, of the form
\code{hooks = list(created = function (worker) {...})}. Or a
\verb{function (job)} that returns the same. Names of
\code{\link[=worker_class]{worker}} hooks are typically \code{'created'},
\code{'submitted'}, \code{'queued'}, \code{'dispatched'}, \code{'starting'}, \code{'running'},
\code{'done'}, or \code{'*'} (duplicates okay). See \code{vignette('hooks')}.}

\item{\code{reformat}}{Set \verb{reformat = function (job)} to define what
\verb{<job>$result} should return. The default, \code{reformat = NULL} passes
\verb{<job>$output} to \verb{<job>$result} unchanged.
See \code{vignette('results')}.}

\item{\code{signal}}{Should calling \verb{<job>$result} signal on condition objects?
When \code{FALSE}, \verb{<job>$result} will return the object without
taking additional action. Setting to \code{TRUE} or a character vector of
condition classes, e.g. \code{c('interrupt', 'error', 'warning')}, will
cause the equivalent of \verb{stop(<condition>)} to be called when those
conditions are produced. Alternatively, a \verb{function (job)} that
returns \code{TRUE} or \code{FALSE}. See \code{vignette('results')}.}

\item{\code{cpus}}{How many CPU cores to reserve for this \code{\link[=job_class]{job}}. Or a
\verb{function (job)} that returns the same. Used to limit the number of
\code{\link[=job_class]{jobs}} running simultaneously to respect
\verb{<jobqueue>$max_cpus}. Does not prevent a \code{\link[=job_class]{job}} from
using more CPUs than reserved.}

\item{\code{stop_id}}{If an existing \code{\link[=job_class]{job}} in the
\code{\link[=jobqueue_class]{jobqueue}} has the same \code{stop_id}, that
\code{\link[=job_class]{job}} will be stopped and return an 'interrupt'
condition object as its result. \code{stop_id} can also be a
\verb{function (job)} that returns the \code{stop_id} to assign to a given
\code{\link[=job_class]{job}}. A \code{stop_id} of \code{NULL} disables this feature.
See \code{vignette('stops')}.}

\item{\code{copy_id}}{If an existing \code{\link[=job_class]{job}} in the
\code{\link[=jobqueue_class]{jobqueue}} has the same \code{copy_id}, the newly
submitted \code{\link[=job_class]{job}} will become a "proxy" for that earlier
\code{\link[=job_class]{job}}, returning whatever result the earlier
\code{\link[=job_class]{job}} returns. \code{copy_id} can also be a \verb{function (job)}
that returns the \code{copy_id} to assign to a given \code{\link[=job_class]{job}}.
A \code{copy_id} of \code{NULL} disables this feature.
See \code{vignette('stops')}.}

\item{\code{...}}{Arbitrary named values to add to the returned \code{\link[=job_class]{job}}
object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The new \code{\link[=job_class]{job}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-submit"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-submit}{}}}
\subsection{Method \code{submit()}}{
Adds a \code{\link[=job_class]{job}} to the \code{\link[=jobqueue_class]{jobqueue}} for
running on a background process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$submit(job)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job}}{A \code{\link[=job_class]{job}} object, as created by \code{job_class$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=jobqueue_class]{jobqueue}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-wait"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-wait}{}}}
\subsection{Method \code{wait()}}{
Blocks until the \code{\link[=jobqueue_class]{jobqueue}} enters the given state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$wait(state = "idle", timeout = NULL, signal = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a \code{\link[=jobqueue_class]{jobqueue}} state. Typically one of:
\itemize{
\item \code{'*'} -        Every time the state changes.
\item \code{'.next'} -    Only one time, the next time the state changes.
\item \code{'starting'} - \code{\link[=worker_class]{workers}} are starting.
\item \code{'idle'} -     All \code{\link[=worker_class]{workers}} are ready/idle.
\item \code{'busy'} -     At least one \code{\link[=worker_class]{worker}} is busy.
\item \code{'stopped'} -  Shutdown is complete.
}}

\item{\code{timeout}}{Stop the \code{\link[=jobqueue_class]{jobqueue}} if it takes longer
than this number of seconds, or \code{NULL}.}

\item{\code{signal}}{Raise an error if encountered (will also be recorded in
\verb{<jobqueue>$cnd}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=jobqueue_class]{jobqueue}}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-on"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-on}{}}}
\subsection{Method \code{on()}}{
Attach a callback function to execute when the
\code{\link[=jobqueue_class]{jobqueue}} enters \code{state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$on(state, func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a \code{\link[=jobqueue_class]{jobqueue}} state. Typically one of:
\itemize{
\item \code{'*'} -        Every time the state changes.
\item \code{'.next'} -    Only one time, the next time the state changes.
\item \code{'starting'} - \code{\link[=worker_class]{workers}} are starting.
\item \code{'idle'} -     All \code{\link[=worker_class]{workers}} are ready/idle.
\item \code{'busy'} -     At least one \code{\link[=worker_class]{worker}} is busy.
\item \code{'stopped'} -  Shutdown is complete.
}}

\item{\code{func}}{A function that accepts a \code{\link[=jobqueue_class]{jobqueue}} object
as input. Return value is ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that when called removes this callback from the
\code{\link[=jobqueue_class]{jobqueue}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobqueue-stop"></a>}}
\if{latex}{\out{\hypertarget{method-jobqueue-stop}{}}}
\subsection{Method \code{stop()}}{
Stop all \code{\link[=job_class]{jobs}} and \code{\link[=worker_class]{workers}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{jobqueue_class$stop(reason = "jobqueue shut down by user", cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reason}}{Passed to \verb{<job>$stop()} for any \code{\link[=job_class]{jobs}}
currently managed by this \code{\link[=jobqueue_class]{jobqueue}}.}

\item{\code{cls}}{Passed to \verb{<job>$stop()} for any \code{\link[=job_class]{jobs}} currently
managed by this \code{\link[=jobqueue_class]{jobqueue}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{\link[=jobqueue_class]{jobqueue}}, invisibly.
}
}
}
