% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_wrappers.R
\name{last_report}
\alias{last_report}
\title{Get the Last Join Report}
\usage{
last_report()
}
\value{
The last \code{JoinReport} object, or \code{NULL} if no join has been performed.
}
\description{
Retrieves the most recent \code{JoinReport} object from any \verb{*_join_spy()} call.
Useful when using \code{.quiet = TRUE} in pipelines and wanting to inspect
the diagnostics afterward.
}
\examples{
orders <- data.frame(id = 1:3, value = c(10, 20, 30))
customers <- data.frame(id = c(1, 2, 4), name = c("A", "B", "D"))

# Silent join in a pipeline
result <- left_join_spy(orders, customers, by = "id", .quiet = TRUE)

# Inspect the report afterward
last_report()

}
\seealso{
\code{\link[=left_join_spy]{left_join_spy()}}, \code{\link[=join_spy]{join_spy()}}
}
