% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_sim.R
\name{sim_data_from_bn}
\alias{sim_data_from_bn}
\title{Simulate data from a Bayesian network}
\usage{
sim_data_from_bn(
  net,
  lvls,
  nsims = 1000,
  increasing_prob = FALSE,
  p1 = 0.8,
  p2 = 1
)
}
\arguments{
\item{net}{A Bayesian network as an igraph object}

\item{lvls}{Named integer vector where each element is the size of the
statespace of the corresponding variable}

\item{nsims}{Number of simulations
distributions from which the simulatios are drawn.}

\item{increasing_prob}{Logical. If true, probabilities in the underlying CPTs
increases with as the number of levels increses.}

\item{p1}{Probability}

\item{p2}{Probability}
}
\description{
Simulate data from a Bayesian network
}
\examples{
net <- igraph::graph(as.character(c(1,2,1,3,3,4,3,5,5,4,2,6,6,7,5,7)), directed = TRUE)
nodes_net <- igraph::V(net)$name
lvls_net  <- structure(sample(3:9, length(nodes_net)), names = nodes_net)
lvls_net  <- structure(rep(3, length(nodes_net)), names = nodes_net)
sim_data_from_bn(net, lvls_net, 10)
}
