% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counter.R
\name{counter}
\alias{counter}
\title{Counter factory.}
\usage{
counter(label, open = NULL, close = NULL, sep = " ", link = FALSE)
}
\arguments{
\item{label}{character. Default prefix for the counter.}

\item{open}{character. Opening bracket such as "(" or "["}

\item{close}{character. Closing bracket such as ")" or "]"}

\item{sep}{character. Separator between label and counter.}

\item{link}{logical. If TRUE, get() method returns a counter
surrounded by a tag, linked to the referenced id.}
}
\value{
List of functions to set and get counters with label.
}
\description{
Define a counter with \code{cnt <- counter("type")}. Add cross-referenced label
in your document with \code{cnt$set("ref")}. Refer to "ref" with \code{cnt$get("ref")}.
}
\examples{
cnt <- counter("Quiz")
cnt$set("aaa")
cnt$set()
cnt$set("bbb", quiet = TRUE)
cnt$get("aaa")
cnt$get("bbb")
cnt$get("aaa", type = "bare")
cnt$dump()
}
