% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/jackknife.R
\docType{methods}
\name{jackknife.MeanDate}
\alias{jackknife.MeanDate}
\alias{jackknife,MeanDate-method}
\title{Jackknife Mean Ceramic Dates}
\usage{
\S4method{jackknife}{MeanDate}(object, f = NULL, calendar = get_calendar())
}
\arguments{
\item{object}{A \code{\linkS4class{MeanDate}} object (typically returned by \code{\link[=mcd]{mcd()}}).}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
the resampling procedure) as argument.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}).}
}
\value{
If \code{f} is \code{NULL}, \code{jackknife()} returns a \code{\link{data.frame}} with the following
elements (else, returns the result of \code{f} applied to the \code{n} resampled
values) :
\describe{
\item{\code{original}}{The observed value.}
\item{\code{mean}}{The jackknife estimate of mean.}
\item{\code{bias}}{The jackknife estimate of bias.}
\item{\code{error}}{The jackknife estimate of standard erro.}
}
}
\description{
Generate jackknife estimations of an \link[=mcd]{MCD}.
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Calculate date midpoints
mid <- vapply(X = dates, FUN = mean, FUN.VALUE = numeric(1))

## Calculate MCD
(mc_dates <- mcd(zuni[100:125, ], dates = mid))

## Get MCD in years CE
time(mc_dates, calendar = CE())

## Bootstrap resampling
boot <- bootstrap(mc_dates, n = 30)
head(boot)

## Jackknife resampling
jack <- jackknife(mc_dates)
head(jack)

## Plot
plot(mc_dates, decreasing = FALSE)
## Add bootstrap confidence intervals
segments(x0 = boot$lower, y0 = seq_len(nrow(boot)),
         x1 = boot$upper, y1 = seq_len(nrow(boot)))
}
\seealso{
\code{\link[=mcd]{mcd()}}

Other resampling methods: 
\code{\link{bootstrap.EventDate}},
\code{\link{bootstrap.MeanDate}},
\code{\link{jackknife.EventDate}}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
