% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{stagingData}
\alias{stagingData}
\title{Staging of colorectal carcinoma}
\format{
A data frame with 21 observations and 6 variables:
\describe{
\item{patho}{the (histo-)pathological staging (gold standard) with categories I, II or III}
\item{rad1}{the clinical staging with categories I, II or III by radiologist 1}
\item{rad2}{the clinical staging with categories I, II or III by radiologist 2}
\item{rad3}{the clinical staging with categories I, II or III by radiologist 3}
\item{rad4}{the clinical staging with categories I, II or III by radiologist 4}
\item{rad5}{the clinical staging with categories I, II or III by radiologist 5}
}
}
\source{
simulated data
}
\usage{
stagingData
}
\description{
Staging of carcinoma is done by different medical professions. Gold standard
is the (histo-)pathological rating of a tissue sample but this information
typically only becomes available late, after surgery. However prior to
surgery the carcinoma is also staged by radiologists in the clinical setting
on the basis of MRI scans.
}
\details{
These fictitious data were inspired by the OCUM trial. The simulation uses
the following two assumptions: over-staging occurs more frequently than
under-staging and an error by two categories is less likely than an error by
only one category.

Stages conform to the UICC classification according to the TNM
classification. Note that cases in stage IV do not appear in this data set
and that the following description of stages is simplified.
\enumerate{
\item \strong{I} Until T2, N0, M0
\item \strong{II} From T3, N0, M0
\item \strong{III} Any T, N1/N2, M0
}
}
\references{
Kreis, M. E. et al., MRI-Based Use of Neoadjuvant
Chemoradiotherapy in Rectal Carcinoma: Surgical Quality and
Histopathological Outcome of the OCUM Trial
\doi{10.1245/s10434-019-07696-y}
}
\keyword{datasets}
