% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_ops.r
\docType{methods}
\name{col_ops}
\alias{col_ops}
\alias{colSums,shaq-method}
\alias{colMeans,shaq-method}
\title{Column Operations}
\usage{
\S4method{colSums}{shaq}(x, na.rm = FALSE, dims = 1L)

\S4method{colMeans}{shaq}(x, na.rm = FALSE, dims = 1L)
}
\arguments{
\item{x}{A shaq.}

\item{na.rm}{Should \code{NA}'s be removed?}

\item{dims}{Ignored.}
}
\value{
A regular vector.
}
\description{
Column operations (currently sums/means) for shaq objects.
}
\section{Communication}{

The operation consists of a local column sum operation, followed by an
\code{allreduce()} call, quadratic on the number of columns.
}

\examples{
\dontrun{
library(kazaam)
x = ranshaq(runif, 10, 3)
cs = colSums(x)
comm.print(cs)

finalize()
}

}
