% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{one_hot}
\alias{one_hot}
\title{One-Hot Encoding for Categorical Data}
\usage{
one_hot(data)
}
\arguments{
\item{data}{a dataframe or matrix where columns are string or factor type covariates}
}
\value{
\item{onehot_data}{a matrix of combined sample and population data with rows corresponding to units and columns one-hot encoded categorical covariates}
}
\description{
Converts raw categorical string/factor data matrix into numeric one-hot encoded data matrix. Intended to help prepare data to be passed to \code{kbal} argument \code{allx} when categorical data is used.
}
\examples{
\donttest{
#Ex 1. Make up some categorical demographic data
dat = data.frame(pid = c(rep("Rep", 20),
                         rep("Dem", 20), 
                         rep("Ind", 20)), 
                 gender = c(rep("female", 35),
                            rep("male", 25)))
#Convert to one-hot encoded data matrix:
onehot_dat = one_hot(dat)
}
#Ex 2. lalonde data
set.seed(123)
data("lalonde")
# Select a random subset of 500 rows
lalonde_sample <- sample(1:nrow(lalonde), 500, replace = FALSE)
lalonde <- lalonde[lalonde_sample, ]

cat_vars=c("black","hisp","married","nodegr","u74","u75")
onehot_lalonde = one_hot(lalonde[, cat_vars])
}
