% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_sparsemax}
\alias{activation_sparsemax}
\title{Sparsemax activation function.}
\usage{
activation_sparsemax(x, axis = -1L)
}
\arguments{
\item{x}{Input tensor.}

\item{axis}{\code{int}, axis along which the sparsemax operation is applied. (1-based)}
}
\value{
A tensor, output of sparsemax transformation. Has the same type and
shape as \code{x}.
}
\description{
For each batch \code{i}, and class \code{j},
sparsemax activation function is defined as:

\verb{sparsemax(x)[i, j] = max(x[i, j] - (x[i, :]), 0).}
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1602.02068}{Martins et.al., 2016}
}
}

\seealso{
Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
