% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{dataset_california_housing}
\alias{dataset_california_housing}
\title{Loads the California Housing dataset.}
\usage{
dataset_california_housing(
  version = "large",
  path = "california_housing.npz",
  test_split = 0.2,
  seed = 113L,
  convert = TRUE
)
}
\arguments{
\item{version}{\code{"small"} or \code{"large"}. The small version
contains 600 samples, the large version contains
20,640 samples. The purpose of the small version is
to serve as an approximate replacement for the
deprecated \code{boston_housing} dataset.}

\item{path}{path where to cache the dataset locally
(relative to \code{Sys.getenv("KERAS_HOME")}).}

\item{test_split}{fraction of the data to reserve as test set.}

\item{seed}{Random seed for shuffling the data
before computing the test split.}

\item{convert}{When \code{TRUE} (default) the datasets are returned as R arrays.
If \code{FALSE}, objects are returned as NumPy arrays.}
}
\value{
Nested list of arrays: \verb{(x_train, y_train), (x_test, y_test)}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{str(dataset_california_housing())
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## List of 2
##  $ train:List of 2
##   ..$ x: num [1:16512, 1:8] -118 -118 -122 -118 -123 ...
##   ..$ y: num [1:16512(1d)] 252300 146900 290900 141300 500001 ...
##  $ test :List of 2
##   ..$ x: num [1:4128, 1:8] -118 -120 -121 -122 -117 ...
##   ..$ y: num [1:4128(1d)] 397900 227900 172100 186500 148900 ...

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{str(dataset_california_housing(convert = FALSE))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## List of 2
##  $ train:List of 2
##   ..$ x: <numpy.ndarray shape(16512,8), dtype=float32>
##   ..$ y: <numpy.ndarray shape(16512), dtype=float32>
##  $ test :List of 2
##   ..$ x: <numpy.ndarray shape(4128,8), dtype=float32>
##   ..$ y: <numpy.ndarray shape(4128), dtype=float32>

}\if{html}{\out{</div>}}
}
\description{
This dataset was obtained from the StatLib repository
(\verb{https://www.dcc.fc.up.pt/~ltorgo/Regression/cal_housing.html}).

It's a continuous regression dataset with 20,640 samples with
8 features each.

The target variable is a scalar: the median house value
for California districts, in dollars.

The 8 input features are the following:
\itemize{
\item MedInc: median income in block group
\item HouseAge: median house age in block group
\item AveRooms: average number of rooms per household
\item AveBedrms: average number of bedrooms per household
\item Population: block group population
\item AveOccup: average number of household members
\item Latitude: block group latitude
\item Longitude: block group longitude
}

This dataset was derived from the 1990 U.S. census, using one row
per census block group. A block group is the smallest geographical
unit for which the U.S. Census Bureau publishes sample data
(a block group typically has a population of 600 to 3,000 people).

A household is a group of people residing within a home.
Since the average number of rooms and bedrooms in this dataset are
provided per household, these columns may take surprisingly large
values for block groups with few households and many empty houses,
such as vacation resorts.
}
\seealso{
Other datasets: \cr
\code{\link{dataset_boston_housing}()} \cr
\code{\link{dataset_cifar10}()} \cr
\code{\link{dataset_cifar100}()} \cr
\code{\link{dataset_fashion_mnist}()} \cr
\code{\link{dataset_imdb}()} \cr
\code{\link{dataset_mnist}()} \cr
\code{\link{dataset_reuters}()} \cr
}
\concept{datasets}
