% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim_kernel.r
\name{estim_kernel}
\alias{estim_kernel}
\title{Discrete Kernel Density Estimator}
\usage{
estim_kernel(
  kernel = c("optimal", "triang", "epanech", "binomial"),
  x,
  h,
  v,
  k = NULL
)
}
\arguments{
\item{kernel}{the type of kernel. Currently supported kernels are limited to:
"optimal", "triang", "epanech" and "binomial"}

\item{x}{the list of target points at which the density is calculated}

\item{h}{the bandwidth (or smoothing parameter)}

\item{v}{the vector of observations}

\item{k}{Optional: the integer (positive) parameter that defined the support
of the kernel function (corresponds to parameter 'a' for triangular
kernel). It is only used for optimal and triangular kernel}
}
\value{
The estimated discrete kernel density values
}
\description{
Discrete Kernel Density Estimator
}
\examples{
n <- 250
mu <- 2 # Mean
x <- 0:10 # target values
y <- sort(rpois(n, mu)) # simulated Poisson observations
# kernel parameters
kernel <- "optimal"
k <- 1
# Cross Validation
H <- seq((max(y) - min(y)) / 200, (max(y) - min(y)) / 2, length.out = 50)
hcv <- cv_bandwidth(kernel = kernel, y, h = H, k = k)
# Kernel estimation
fn_opt_k <- estim_kernel(kernel = kernel, x = x, h = hcv, v = y, k = k)
}
