% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{kpnode}
\alias{kpnode}
\title{Return the most central player in sequentially reduced networks}
\usage{
kpnode(
  adj.matrix,
  type,
  M = Inf,
  T = ncol(adj.matrix),
  method,
  binary = FALSE,
  cmode,
  large = TRUE,
  geodist.precomp = NULL
)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{type}{\code{type="betweenness"} for \code{\link[sna]{betweenness}} centrality. \cr
\code{type="closeness"} for \code{\link[sna]{closeness}} centrality. \cr
\code{type="degree"} for \code{\link[sna]{degree}} centraslity. \cr
\code{type="diffusion"} for \code{\link{diffusion}} centrality. \cr
\code{type="evcent"} for \code{\link[sna]{evcent}} (eigenvector) centrality. \cr
\code{type="fragment"} for \code{\link{fragment}} centrality. \cr
\code{type="mreach.degree"} for \code{\link{mreach.degree}} centrality. \cr
\code{type="mreach.closeness"} for \code{\link{mreach.closeness}} centrality. \cr}

\item{M}{Positive number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected. The default is
\code{Inf}. The option is applicable to mreach.degree, mreach.closeness,
and fragmentation centralities.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. For diffusion centrality only.
In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}

\item{method}{Indication of which grouping criterion should be used. \cr
\code{"min"} indicates the "minimum" criterion and is suggested for
betweenness, closeness, fragmentation, and M-reach centralities. \cr
\code{"max"} indicates the "maximum" criterion and is suggested for
degree and eigenvector centralities.\cr
\code{"add"} indicates the "addition" criterion and is suggested for
degree and eigenvector centralities as an altenative of "max".\cr
\code{"union"} indicates the "union" criterion and is suggested for
diffusion centrality.\cr
By default, kpset uses "min".
See \code{\link{kpcent}} Details section for explanations on grouping method.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. By default, \code{binary=FALSE}}

\item{cmode}{String indicating the type of centrality being evaluated.
The option is applicable to degree and M-reach centralities.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and (total) degree respectively. \code{"all"} reports
all the above measures. The default is to report the total degree.
The option also applies to closeness centrality, but with different options.
The default is to use the Gil-Schmidt power index as the closeness measure.
See \code{\link[sna]{closeness}} for complete options.}

\item{large}{Logical scalar, whether the computation method for large network is
implemented. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used; otherwise the method implemented in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the graph to be
analyzed (optional).}
}
\value{
The most central player and its centrality score
}
\description{
\code{kpnode} returns the node with the highest centrality score.
}
\keyword{internal}
