% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{kpset}
\alias{kpset}
\title{Selecting the Most Central Group of Players in a Network}
\usage{
kpset(
  adj.matrix,
  size,
  type = "degree",
  M = Inf,
  T = ncol(adj.matrix),
  method = "min",
  binary = FALSE,
  cmode = "total",
  large = TRUE,
  geodist.precomp = NULL,
  seed = "top",
  parallel = FALSE,
  cluster = 2,
  round = 10,
  iteration = ncol(adj.matrix)
)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network or in the case of diffusion centrality a probability matrix.}

\item{size}{Integer indicating the target size of players.}

\item{type}{A string indicating the type of centrality measure to be used. Should be one of \code{"degree"} for degree centrality,
\code{"closeness"} for closeness centrality, \code{"betweenness"} for betweenness centrality, \code{"evcent"} for eigenvector centrality,
\code{"mreach.degree"} for M-reach degree centrality, \code{"mreach.closeness"} for M-reach closeness centrality,
\code{"fragment"} for fragment centrality, and \code{"diffusion"} for diffusion centrality.}

\item{M}{Positive number indicating the maximum geodistance between two nodes,
above which the two nodes are considered disconnected. The default is \code{Inf}.
The option is applicable to M-reach degree, M-reach closeness, and fragmentation centralities..}

\item{T}{Integer indicating the maximum number of iterations
in the communication process. By default, T is the network size.}

\item{method}{Indication of which grouping criterion should be used. \cr
\code{"min"} indicates the "minimum" criterion and is suggested for
betweenness, closeness, fragmentation, and M-reach centralities. \cr
\code{"max"} indicates the "maximum" criterion and is suggested for
degree and eigenvector centralities.\cr
\code{"add"} indicates the "addition" criterion and is suggested for
degree and eigenvector centralities as an altenative of "max".\cr
\code{"union"} indicates the "union" criterion and is suggested for
diffusion centrality.\cr
The default is "min".
See \code{\link{kpcent}} Details section for explanations on grouping method.}

\item{binary}{If \code{TRUE}, the input matrix is binarized.
If \code{FALSE}, the edge values are considered. The default is \code{FALSE}.}

\item{cmode}{String indicating the type of centrality being evaluated.
The option is applicable to degree and M-reach centralities.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and total degree, respectively. \code{"all"} reports
all the above measures. The default is to report the total degree.
Note for closeness centrality, we use the Gil-Schmidt power index when \code{large=FALSE}.
See \code{\link[sna]{closeness}} for explanation. When
large=\code{TRUE}, the function reports the standard closeness score.}

\item{large}{Logical scalar. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used for computing geodistance and related centrality measures; otherwise the method in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the network to be
analyzed (optional).}

\item{seed}{String indicating the seeding method or a vector of the seeds specified by user.
If \code{"top"}, players with the high individual centrality
are used as the seeds. If \code{"random"}, seeds are randomly sampled.
The default is \code{"top"} for efficiency.}

\item{parallel}{Logical scalar. IF \code{TRUE}, the parallel computation is
implement. The default is \code{FALSE}.}

\item{cluster}{Integer indicating the number of CPU cores to be used for parallel computation.}

\item{round}{Integer indicating the "length" of search,
namely, the number of loops over the nodes in the candidate set.}

\item{iteration}{Integer indicating the "width" of search in each round,
namely, the number of loops over the nodes in the residual set.}
}
\value{
\code{kpset} returns the column indices of the players who form
the most central set and its centrality score.
}
\description{
\code{kpset} helps identify the most central group of players in a social network given a sepcified centraliy measure and a target group size.
}
\details{
The most central group of players in a network is not necessarily the set of players who are the most
central as individuals because there may be redundancy in their connections.
Currenlty a greedy search algorithm is implemented in this package to identify the most central group of key players. The basic steps are shown as follows.
\enumerate{
\item Select an initial candidate set \emph{C}. The residual set is denoted as \emph{R}.
\item Update the candidate set \emph{C}.
\itemize{
 \item Start with the first node in \emph{C}. Try to swap it with nodes in \emph{R} sequentially (loop 1).
 Make the swap if it improves the centrality score of the resulting \emph{C}.
 The number of loop 1 is defined as the number of iterations (over the nodes in the residual set).
 \item Repeat step 1 for each node in \emph{C} sequentially (loop 2). The number of loop 2 is
  defined as the number of rounds (over the nodes in the candidate set).
  \item Stop if (a) the change in \emph{C}'s centrality score is negligible
        (i.e. it is smaller than a pre-specified threshold determined by both
        the network size and edge values.)
        or (b) the process reaches a specified number
        of rounds.
  }
\item Return the final candidate set and the centrality score.
}

It is recommended to run \code{kpset} several times with different seeds so that the algorithm will not be trapped in a local optimum.
To facilitate the search in large networks, users may specify a reasonable number of iterations
or rounds and/or utilize parallel computation. During parallel computation, for each cluster and each iteration
the algorithm randomly picks a node from the candidate set and the residual set, respectively,
and swaps the two if it improves the centrality score of the candidate set. It repeats this process until exhausting the specified iterations and rounds
and then compare and combine the results from the clusters.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Find the most central player set sized 2 in terms of the degree centrality
kpset(W,size=2,type="degree")

# Find two most central players in terms of indegree
# via parallel computation using 5 cpu cores
kpset(W,size=2,type="degree", cmode="indegree", parallel = TRUE, cluster = 2)

}
\references{
An, Weihua. (2015). "Multilevel Meta Network Analysis with Application to Studying Network Dynamics of Network Interventions." \emph{Social Networks} 43: 48-56.\cr

An, Weihua and Yu-Hsin Liu (2016). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{The R Journal}, 8(1): 257-268.\cr

Borgatti, Stephen P. (2006). "Identifying Sets of Key Players in a Network." \emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr

Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{https://CRAN.R-project.org/package=sna}\cr

Csardi, G and Nepusz, T (2006). "The igraph software package for complex network research."
InterJournal, Complex Systems 1695. \url{https://igraph.org} \cr
}
\seealso{
\code{\link{kpcent}}
}
\author{
Weihua An \email{weihua.an@emory.edu}; Yu-Hsin Liu \email{ugeneliu@meta.com}
}
