% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{mreach.closeness}
\alias{mreach.closeness}
\title{Compute the M-reach Closeness Centrality Score in a Netwrok}
\usage{
mreach.closeness(
  adj.matrix,
  node,
  M = Inf,
  binary = FALSE,
  cmode = "all",
  large = TRUE,
  geodist.precomp = NULL
)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{node}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If not specified, scores for all nodes will be reported.}

\item{M}{Number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected.
M hence defines the reachable set. The default is \code{Inf}.}

\item{binary}{Logical scalar. If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered.}

\item{cmode}{String indicating the type of centrality being evaluated.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and (total) degree respectively. \code{"all"} reports
all the above measures and is the default.}

\item{large}{Logical scalar, whether the computation method for large network is
implemented. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used; otherwise the method implemented in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the graph to be
analyzed (optional).}
}
\value{
A vector indicating the outdegree, indegree, or total-degree
cohesion score of the chosen player; or a data frame containing all
the above information. Note that the outdegree and indegree scores are normalized
to [0,1]. This means that the total-degree score is between [0,2].
}
\description{
\code{mreach.closeness} refines the \code{\link{mreach.degree}} centrality by
using the (inverse) geodistance as weights.
The edge values should be properly interpreted as distances.
}
\details{
\code{mreach.closeness} refines the \code{\link{mreach.degree}} centrality
by using the (inverse) geodistance as weights, just as \code{\link[sna]{closeness}}
centrality refines \code{\link[sna]{degree}} centrality.
It captures the degree centrality when M is properly set (e.g. M=1 in a binarized network).
It captures the Gil-Schmidt power index (Gil and Schmidt, 1996)
and the cohesion centrality (Borgatti, 2006) when M is sufficiently large
(unconstrained). The normalization factor takes care of non-binary
edge values. Also note that the geodistance matrix does
not necessarily to be symmetric.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Transform the edge value to distance interpretaion
A <- W
A[W!=0] <- 1/W[W!=0]

# List all types of 2-reach closeness scores for every node
mreach.closeness(A,M=2,cmode="all",large=FALSE)

}
\references{
An, Weihua and Yu-Hsin Liu (2016). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{The R Journal}, 8(1): 257-268.\cr

Borgatti, Stephen P. (2006). "Identifying Sets of Key Players in a Network."
\emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr

Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{https://cran.r-project.org/package=sna}\cr

Csardi, G and Nepusz, T (2006). "The igraph software package for complex network research."
InterJournal, Complex Systems 1695. \url{https://igraph.org/} \cr

Gil, J and Schmidt, S (1996). "The Origin of the Mexican Network of Power."
Proceedings of the International Social Network Conference, Charleston, SC, 22-25.\cr
}
\seealso{
\code{\link[sna]{geodist}};
\code{\link[igraph]{shortest.paths}};
\code{\link{mreach.degree}};
\code{\link{kpcent}};
\code{\link{kpset}}
}
\author{
Weihua An \email{weihua.an@emory.edu}; Yu-Hsin Liu \email{ugeneliu@meta.com}
}
