% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{class_esrd_outcome}
\alias{class_esrd_outcome}
\title{Label CKD stages or ESRD outcomes.}
\usage{
class_esrd_outcome(
  df,
  col,
  years,
  duration_col,
  prefix = NULL,
  create_years_col = TRUE
)
}
\arguments{
\item{df}{Data frame with an eGFR column.}

\item{col}{Column name with ESRD event indicator, 0 or 1.}

\item{years}{Integer horizon, 2 or 5.}

\item{duration_col}{Column name with follow up time in days.}

\item{prefix}{Optional prefix for the derived outcome column.}

\item{create_years_col}{Logical, add a \verb{<years>_year_outcome} column.}
}
\value{
The modified data frame with added label columns.
}
\description{
Label CKD stages or ESRD outcomes.
}
\examples{
df <- data.frame(
  eGFR = c(90, 45, 25, 10),
  esrd = c(0, 0, 1, 0),
  followup_days = c(365, 800, 500, 1200)
)
class_esrd_outcome(
  df,
  col = "esrd",
  years = 2,
  duration_col = "followup_days"
)

}
