% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-train-nn-parsnip.R
\name{train_nnsnip}
\alias{train_nnsnip}
\title{Parsnip Interface of \code{train_nn()}}
\usage{
train_nnsnip(
  mode = "unknown",
  engine = "kindling",
  hidden_neurons = NULL,
  activations = NULL,
  output_activation = NULL,
  bias = NULL,
  epochs = NULL,
  batch_size = NULL,
  penalty = NULL,
  mixture = NULL,
  learn_rate = NULL,
  optimizer = NULL,
  validation_split = NULL,
  optimizer_args = NULL,
  loss = NULL,
  architecture = NULL,
  flatten_input = NULL,
  early_stopping = NULL,
  device = NULL,
  verbose = NULL,
  cache_weights = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. Possible values
are "unknown", "regression", or "classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Currently only "kindling" is supported.}

\item{hidden_neurons}{An integer vector for the number of units in each hidden
layer. Can be tuned.}

\item{activations}{A character vector of activation function names for each
hidden layer (e.g., "relu", "tanh", "sigmoid"). Can be tuned.}

\item{output_activation}{A character string for the output activation function.
Can be tuned.}

\item{bias}{Logical for whether to include bias terms. Can be tuned.}

\item{epochs}{An integer for the number of training iterations. Can be tuned.}

\item{batch_size}{An integer for the batch size during training. Can be tuned.}

\item{penalty}{A number for the regularization penalty (lambda). Default \code{0}
(no regularization). Higher values increase regularization strength. Can be tuned.}

\item{mixture}{A number between 0 and 1 for the elastic net mixing parameter.
Default \code{0} (pure L2/Ridge regularization).
\itemize{
\item \code{0}: Pure L2 regularization (Ridge)
\item \code{1}: Pure L1 regularization (Lasso)
\item \verb{0 < mixture < 1}: Elastic net (combination of L1 and L2)
Only relevant when \code{penalty > 0}. Can be tuned.
}}

\item{learn_rate}{A number for the learning rate. Can be tuned.}

\item{optimizer}{A character string for the optimizer type ("adam", "sgd",
"rmsprop"). Can be tuned.}

\item{validation_split}{A number between 0 and 1 for the proportion of data
used for validation. Can be tuned.}

\item{optimizer_args}{A named list of additional arguments passed to the
optimizer. Cannot be tuned — pass via \code{set_engine()}.}

\item{loss}{A character string or a valid \code{{torch}} function for the loss function ("mse", "mae",
"cross_entropy", "bce"). Cannot be tuned — pass via \code{set_engine()}.}

\item{architecture}{An \code{\link[=nn_arch]{nn_arch()}} object for a custom architecture. Cannot
be tuned — pass via \code{set_engine()}.}

\item{flatten_input}{Logical or \code{NULL}. Controls input flattening. Cannot be
tuned — pass via \code{set_engine()}.}

\item{early_stopping}{An \code{\link[=early_stop]{early_stop()}} object or \code{NULL}. Cannot be tuned —
pass via \code{set_engine()}.}

\item{device}{A character string for the device to use ("cpu", "cuda", "mps").
If \code{NULL}, auto-detects the best available device. Cannot be tuned — pass
via \code{set_engine()}.}

\item{verbose}{Logical for whether to print training progress. Default \code{FALSE}.
Cannot be tuned — pass via \code{set_engine()}.}

\item{cache_weights}{Logical. If \code{TRUE}, stores trained weight matrices in
the returned object. Cannot be tuned — pass via \code{set_engine()}.}
}
\value{
A model specification object with class \code{train_nnsnip}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{train_nnsnip()} defines a neural network model specification that can be used
for classification or regression. It integrates with the tidymodels ecosystem
and uses \code{\link[=train_nn]{train_nn()}} as the fitting backend, supporting any architecture
expressible via \code{\link[=nn_arch]{nn_arch()}} — feedforward, recurrent, convolutional, and beyond.
}
\details{
This function creates a model specification for a neural network that can be
used within tidymodels workflows. The underlying engine is \code{\link[=train_nn]{train_nn()}}, which
is architecture-agnostic: when \code{architecture = NULL} it falls back to a
standard feed-forward network, but any architecture expressible via \code{\link[=nn_arch]{nn_arch()}}
can be used instead. The model supports:
\itemize{
\item Configurable hidden layers and activation functions (default MLP path)
\item Custom architectures via \code{\link[=nn_arch]{nn_arch()}} (recurrent, convolutional, etc.)
\item GPU acceleration (CUDA, MPS, or CPU)
\item Hyperparameter tuning integration
\item Both regression and classification tasks
}

When using the default MLP path (no custom \code{architecture}), \code{hidden_neurons}
accepts an integer vector where each element represents the number of neurons
in that hidden layer. For example, \code{hidden_neurons = c(128, 64, 32)} creates
a network with three hidden layers. Pass an \code{\link[=nn_arch]{nn_arch()}} object via
\code{set_engine()} to use a custom architecture instead.

The \code{device} parameter controls where computation occurs:
\itemize{
\item \code{NULL} (default): Auto-detect best available device (CUDA > MPS > CPU)
\item \code{"cuda"}: Use NVIDIA GPU
\item \code{"mps"}: Use Apple Silicon GPU
\item \code{"cpu"}: Use CPU only
}

When tuning, you can use special tune tokens:
\itemize{
\item For \code{hidden_neurons}: use \code{tune("hidden_neurons")} with a custom range
\item For \code{activation}: use \code{tune("activation")} with values like "relu", "tanh"
}
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
    box::use(
        recipes[recipe],
        workflows[workflow, add_recipe, add_model],
        tune[tune],
        parsnip[fit]
    )

    # Model spec
    nn_spec = train_nnsnip(
        mode = "classification",
        hidden_neurons = c(30, 5),
        activations = c("relu", "elu"),
        epochs = 100
    )

    wf = workflow() |>
        add_recipe(recipe(Species ~ ., data = iris)) |>
        add_model(nn_spec)

    fit_wf = fit(wf, data = iris)
} else {
    message("Torch not fully installed — skipping example")
}
}

}
