% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-transformation.R
\name{to_uniform_scale}
\alias{to_uniform_scale}
\title{Transform samples to uniform scale}
\usage{
to_uniform_scale(X, Y)
}
\arguments{
\item{X, Y}{\code{n}-by-\code{d} and \code{m}-by-\code{d} matrices, representing \code{n} samples from
the true distribution \eqn{P} and \code{m} samples from the approximate distribution
\eqn{Q}, both in \code{d} dimensions. Vector input is treated as a column matrix.
\code{Y} can be left blank if \code{q} is specified (see below).}
}
\value{
A list with fields \code{X} and \code{Y}, containing the transformed samples.
}
\description{
Since Kullback-Leibler divergence is scale-invariant, its sample-based
approximations can be computed on a conveniently chosen scale. This helper
functions transforms each variable in a way that all marginal distributions
of the joint dataset \eqn{(X,Y)} are uniform. In this way, the scales of
different variables are rendered comparable, with the idea of a better
performance of neighbour-based methods in this situation.
}
\examples{
# 2D example
n <- 10L
X <- cbind(rnorm(n, mean = 0, sd = 3),
           rnorm(n, mean = 1, sd = 2))
Y <- cbind(rnorm(n, mean = 1, sd = 2),
           rnorm(n, mean = 0, sd = 2))
to_uniform_scale(X, Y)
}
