% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knobi_retro.R
\name{knobi_retro}
\alias{knobi_retro}
\title{KBPM retrospective analysis}
\arguments{
\item{knobi_results}{The object resulting from the \code{\link{knobi_fit}} function, which are the results of the base KBPM fit.}

\item{nR}{Number of retrospective peels to fit the model peeling off from 1 to nR years of data. 5 by default. See details.}

\item{yR}{Optional. A vector representing the final years of the catch time series for each of the retrospective models. See details.}

\item{yR0}{Optional. A vector representing the starting years of the catch time series for each of the retrospective models. This vector must be the same length as the yR vector. By default, the catch time series is assumed to start in the same year as the original fit.}

\item{env_results}{Optional. The object resulting from the \code{\link{knobi_env}} function. A list containing the results of the environmental KBPM fit. If this argument is provided, the retrospective analysis is carried out for the base and the environmental KBPM models.}

\item{plot_out}{Logical. If TRUE, a file containing the plot of the retrospective fits is created. The default value is the input in the \code{\link{knobi_fit}} function.}

\item{plot_dir}{Optional. Directory to create the folder and save the plots. Required when 'plot_out=TRUE'. The default value is taken from the input of the \code{\link{knobi_fit}} function.}

\item{plot_filename}{Optional. Name of the folder that will contain the plots. Required when 'plot_out=TRUE'. The default value is taken from the input of the \code{\link{knobi_fit}} function.}
}
\value{
A list containing the results of the retrospective analysis, including parameter estimates and reference points for each model. The estimated surplus production curves from the retrospective analysis are also plotted, with a panel where each graph represents the curves for each model in case of considering environmental models. The plot is displayed in the plot window and saved (if plot_out=TRUE) in the specified directory or in the current directory.
}
\description{
This function performs a retrospective analysis that evaluates the robustness of the KBPM fit to the systematic deletion of recent data.
}
\details{
There are different options for defining retrospective fits:  

(1) Usage of \code{nR} argument. This argument specifies the number of retrospective peels. By using this argument, it is implied that the retrospective fits will consist of systematically deleting the last year of data, up to the number of years specified by \code{nR}.  

(2) Usage of \code{yR} argument. This argument specifies the final years of the catch time series for each of the retrospective models, providing greater flexibility in choosing the years from which to delete information. The number of retrospective fits will correspond to the length of the \code{yR} vector. Additionally, different starting years can be set using the \code{yR0} argument. 

If both arguments, \code{nR} and \code{yR}, are provided, the package will prioritize the use of \code{yR}.

As described in the \code{\link{knobi_env}} function details, in the case of the environmental models, both the estimated biological reference points and the plotted production curve correspond to a value of the scaled environmental variable equal to the mean of the time series, i.e. \eqn{X_{t}=0}, which cancels out the environmental effect in the equations defining both models. For more details, such as the calculation of BRPs as a function of the environmental variable, see vignettes.
}
\examples{

\donttest{

library(knobi)

# See knobi_fit example to obtain the knobi_results object
knobi_retrospectives<-knobi_retro(knobi_results,plot_out=T)  # default nR=5
knobi_retrospectives

knobi_retro(knobi_results,nR=3)
knobi_retro(knobi_results,yR=c(2010,2015))
knobi_retro(knobi_results,yR=c(2010,2015),yR0=c(1995,2000))

# See knobi_env example to obtain the env_results object
knobi_retro(knobi_results,env_results=knobi_environmental,yR=c(2010,2015),yR0=c(1995,2000))

}

}
\author{
\itemize{
\item{Anxo Paz}
\item{Marta Cousido-Rocha}
\item{Santiago Cerviño López}
\item{M. Grazia Pennino}
}
}
