% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ko.ordinal.R
\name{ko.ordinal}
\alias{ko.ordinal}
\title{Statistics of the knockoffs procedure for ordinalNet regression models.}
\usage{
ko.ordinal(x, y, family = "cumulative", reverse = FALSE,
  link = "logit", alpha = 1, parallelTerms = TRUE,
  nonparallelTerms = FALSE, nVal = 100, warn = FALSE,
  random = FALSE)
}
\arguments{
\item{x}{Covariate matrix, of dimension nobs x nvars; each row is an observation vector. It is recommended that categorical covariates are converted to a set of indicator variables with a variable for each category (i.e. no baseline category); otherwise the choice of baseline category will affect the model fit.}

\item{y}{Response variable. Can be a factor, ordered factor, or a matrix where each row is a multinomial vector of counts. A weighted fit can be obtained using the matrix option, since the row sums are essentially observation weights. Non-integer matrix entries are allowed.}

\item{family}{Specifies the type of model family. Options are "cumulative" for cumulative probability, "sratio" for stopping ratio, "cratio" for continuation ratio, and "acat" for adjacent category.}

\item{reverse}{Logical. If TRUE, then the "backward" form of the model is fit, i.e. the model is defined with response categories in reverse order. For example, the reverse cumulative model with K+1 response categories applies the link function to the cumulative probabilities P(Y >= 2), …, P(Y >= K+1), rather then P(Y <= 1), …, P(Y <= K).}

\item{link}{Specifies the link function. The options supported are logit, probit, complementary log-log, and cauchit.}

\item{alpha}{The elastic net mixing parameter, with \code{0 <= alpha <= 1}. \code{alpha=1} corresponds to the lasso penalty, and \code{alpha=0} corresponds to the ridge penalty.}

\item{parallelTerms}{Logical. If \code{TRUE}, then parallel coefficient terms will be included in the model. \code{parallelTerms} and \code{nonparallelTerms} cannot both be \code{FALSE}.}

\item{nonparallelTerms}{Logical. if \code{TRUE}, then nonparallel coefficient terms will be included in the model. \code{parallelTerms} and \code{nonparallelTerms} cannot both be \code{FALSE}. Default is \code{FALSE}. \code{nonparallelTerms = TRUE} is highly discouraged.}

\item{nVal}{Length of lambda sequence - default is 100.}

\item{warn}{Logical. If \code{TRUE}, the following warning message is displayed when fitting a cumulative probability model with \code{nonparallelTerms=TRUE} (i.e. nonparallel or semi-parallel model). "Warning message: For out-of-sample data, the cumulative probability model with \code{nonparallelTerms=TRUE} may predict cumulative probabilities that are not monotone increasing." The warning is displayed by default, but the user may wish to disable it.}

\item{random}{If \code{TRUE}, the matrix of knockoffs is different for every run. If \code{FALSE}, a seed is used so that the knockoffs are the same. The default is \code{FALSE}.}
}
\value{
A vector of dimension nvars corresponding to the statistics W.
}
\description{
Returns the vector of statistics W of the revisited knockoffs procedure for regressions available in the R package \code{ordinalNet}. Most of the parameters come from \code{ordinalNet()}. See \href{https://CRAN.R-project.org/package=ordinalNet}{\code{ordinalNet} documentation} for more details.
}
\note{
\code{nonparallelTerms = TRUE} is highly discouraged because the knockoffs procedure does not suit well to this setting.
}
\examples{
# see ko.sel


}
\seealso{
\code{\link{ko.sel}}
}
