% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_adjusted.R
\name{r2_adjusted}
\alias{r2_adjusted}
\title{Calculate the adjusted determination coefficient}
\usage{
r2_adjusted(model, r2)
}
\arguments{
\item{model}{A linear model or power regression model of the \code{lm}.}

\item{r2}{A numeric. Coefficient of determination.}
}
\value{
A numeric vector or a list of class \code{r2_kvr2} containing the adjusted \eqn{R^2} values.
Each element represents the adjusted version of the corresponding \eqn{R^2} definition, accounting for the degrees of freedom.
}
\description{
Calculate the adjusted coefficient of determination by entering the regression model and coefficient of determination.
See details.
}
\details{
The adjustment factor \eqn{a} is calculated using the following formula.
\deqn{a = (n - 1) / (n - k - 1)}
\eqn{n} is the sample size, and \eqn{k} is the number of parameters in the regression model.

\eqn{R^2_a} (\eqn{R^2 adjusted}) is calculated using the following formula.
\deqn{R^2_a = 1 - a (1 - R^2)}

This function performs freedom-of-degrees adjustment for all coefficients based on the above formula. However, Kvalseth (1985) recommends applying freedom-of-degrees adjustment only to \eqn{R^2_1} and \eqn{R^2_9}, based on the principle of consistency in coefficients.
Furthermore, there is no basis for applying the same type of adjustment to \eqn{R^2_6} (the square of the correlation coefficient) or to \eqn{R^2_7} and \eqn{R^2_8}, which depend on specific model forms.

For details on each coefficient of determination, refer to \code{\link[=r2]{r2()}}.
}
\references{
Tarald O. Kvalseth (1985) Cautionary Note about R 2 , The American Statistician, 39:4, 279-285, \doi{10.1080/00031305.1985.10479448}
}
\seealso{
\code{\link[=r2]{r2()}}
}
