% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmmplot.R
\name{gmmplot}
\alias{gmmplot}
\title{Plot the Fit Results of 2-Component Gaussian Mixture Model}
\usage{
gmmplot(x, mu1, mu2, sigma, lambda, nbins = 15, xlim)
}
\arguments{
\item{x}{a numeric vector}

\item{mu1}{the mean of the 1st cluster}

\item{mu2}{the mean of the 2nd cluster}

\item{sigma}{the common variance of both clusters}

\item{lambda}{the proportion parameter}

\item{nbins}{the number of bins per cluster (6*sigma)}

\item{xlim}{the limitation of x scale}
}
\description{
Plot the Fit Results of 2-Component Gaussian Mixture Model
}
\examples{
set.seed(0)
x=list(c(
  rnorm(150, mean=0)
  , rnorm(50, mean=10)
  ))
fit_res=multigmmsamedistribu(x)

with(
  as.list(fit_res$par_conv)
  , gmmplot(x[[1]]
    , mu1=mu1
    , mu2=mu2
    , sigma=sigma
    , lambda=lambda
    , xlim=range(unlist(x))
    )
  )
}
\keyword{distribution}
