% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_para_mn.R
\name{lsm_l_para_mn}
\alias{lsm_l_para_mn}
\title{PARA_MN (landscape level)}
\usage{
lsm_l_para_mn(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean perimeter-area ratio (Shape metric)
}
\details{
\deqn{PARA_{MN} = mean(PARA[patch_{ij}]}
where \eqn{PARA[patch_{ij}]} is the perimeter area ratio of each patch.

PARA_MN is a 'Shape metric'. It summarises the landscape as the mean of
each patch in the landscape. The perimeter-area ratio describes the patch complexity
in a straightforward way. However, because it is not standarised to a certain shape
(e.g. a square), it is not scale independent, meaning that increasing the patch size
while not changing the patch form will change the ratio.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{None}
\subsection{Range}{PARA_MN > 0}
\subsection{Behaviour}{Approaches PARA_MN > 0 if PARA for each patch approaches PARA > 0,
i.e. the form approaches a rather small square. Increases, without limit, as PARA increases,
i.e. patches become more complex.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_para_mn(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_para}},
\code{\link[base]{mean}}, \cr
\code{\link{lsm_c_para_mn}},
\code{\link{lsm_c_para_sd}},
\code{\link{lsm_c_para_cv}}, \cr
\code{\link{lsm_l_para_sd}},
\code{\link{lsm_l_para_cv}}
}
