% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmm.fixed.R
\name{loopcov-ergmTerm}
\alias{loopcov-ergmTerm}
\alias{InitErgmTerm.loopcov}
\title{Covariate effect on self-loops}
\usage{
# binary: loopcov(attrname, mean=0, var=9)

# valued: loopcov(attrname, mean=0, var=9)
}
\arguments{
\item{attrname}{a character string giving the name of a numeric
(not categorical) attribute in the network's vertex attribute
list.}

\item{mean, var}{prior mean and variance.}
}
\description{
This term adds one covariate to the model, for which
\code{x[i,i]=attrname(i)} and \code{x[i,j]=0} for \code{i!=j}.
This term only makes sense if the network has self-loops.

\strong{Important:} This term works in \CRANpkg{latentnet}'s \code{\link[=ergmm]{ergmm()}} only. Using it in \code{\link[ergm:ergm]{ergm()}} will result in an error.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "loopcov", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{latent}
\concept{quantitative nodal attribute}
\concept{undirected}
