% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editLattice.R
\name{editLattice}
\alias{editLattice}
\title{Add or remove links in the lattice}
\usage{
editLattice(formLatticeOutput)
}
\arguments{
\item{formLatticeOutput}{An object from formLattice or editLattice.}
}
\value{
a formLatticeOutput object, which contains
\itemize{
  \item EWlocs EW coordinates for use in contour.
  \item NSlocs NS coordinates for use in contour.
  \item nodes Matrix of node locations.
  \item poly Matrix of vertices of the boundary polygon.
  \item latt Lattice object as generated by dnearneigh of package spdep.
  }
}
\description{
editLattice is an interactive editor 
based on the function edit.nb from the 
package spdep. A formLatticeOutput object 
includes an automatically generated 
neighborhood structure. Occasionally 
this will either leave two nodes disconnected 
that should be connected or vice versa. 
editLattice allows the user to directly edit 
the plot of the lattice using mouseclicks to 
add or remove neighbor links between nodes.
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput = nodeFilling(poly=polygon1, node_spacing=0.03)
plot(nodeFillingOutput)
formLatticeOutput = formLattice(nodeFillingOutput)
plot(formLatticeOutput)
if(interactive()){
formLatticeOutput = editLattice(formLatticeOutput)
}
#
Pointdata = splancs::csr(polygon1,20)
densityOut = createDensity(formLatticeOutput,PointPattern=Pointdata,
                  k=150,intensity=FALSE, sparse = TRUE)
plot(densityOut)

}
\seealso{
formLattice
}
\author{
Ronald P. Barry
}
