% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbm.R
\name{lbm}
\alias{lbm}
\title{Log binomial regression model in Exact method}
\usage{
lbm(formula, data,contrasts = NULL,subset,na.action,lfv=0.95,
           vce = "oim",rescode=NULL,control=lbm.control(),\dots)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}" (or one that
can be coerced to that class): a symbolic description of the model
to be fitted. The details of model specification are given under \sQuote{Details}.}

\item{data}{an optional data frame, list or environment (or object
coercible by \code{as.data.frame} to a data frame) containing the variables
in the model. If not found in \code{data}, the variables are taken from
\code{environment(formula)}, typically the environment from which \code{lbm}
is called.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of
\code{model.matrix.default}.}

\item{subset}{a specification of the rows to be used: defaults to all rows.
This can be any valid indexing vector (see [\code{.data.frame}] for the
rows of data or if that is not supplied, a data frame made up of the
variables used in formula.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{\link[stats]{na.action}}, and is \code{\link[stats]{na.fail}} if that
is unset. The 'factory-fresh' default is \code{\link[stats]{na.omit}}.
Another possible value is \code{NULL}, no action. Value
\code{\link[stats]{na.exclude}} can be useful.}

\item{lfv}{a testing range option which decides the range of boundary vector candidates included for testing.
The default value is 0.95, which means the covariate vectors with probability
greater than 0.95 will be included into boundary pairing system as boundary vector candidates.}

\item{vce}{the type of the information matrix used to attain the variance-covariance matrix.
Two options could be selected, observed information matrix (OIM) and expected information
matrix (EIM). The default \code{vce} is \code{"OIM"}. This argument only works in the data with
boundary vector. If there is no boundary vector included in the data, the results
are from \code{glm}. In the \code{glm}, the standard error is calculated
by expected information matrix.}

\item{rescode}{is an option to code the response variable if it is a factor.}

\item{control}{The \code{control} argument of \code{lbm} is by default passed to the arguments of \code{\link{lbm.control}}.}

\item{\dots}{For \code{lbm}, arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
\code{lbm} returns an object of class inheriting from \code{"lbm"} which
inherits from the class \code{"lbm"}. The function \code{summary} (i.e.,
\code{summary.lbm}) can be used to obtain or print a summary of the estimates
and the relevant confidence interval. The argument \code{CF.lvl} in
\code{summary} represents the level of confidence interval claimed in the
model. The default value is \code{CF.lvl=0.95}. Optionally, Risk ratio estimates
and their related confidence interval are offered as an argument \code{RR} in
the \code{summary}. The default \code{RR=FALSE} is not to display them.

An object of class \code{"lbm"} is a list containing at least the following
components:

\item{coefficients}{a named vector of coefficients}
\item{residuals}{the working residuals, that is the residuals in the final
iteration of the IWLS fit.}
\item{fitted.values}{the fitted mean values, obtained by transforming the
linear predictors by the inverse of the log link function.}
\item{linear.predictors}{the linear fit on log scale.}
\item{deviance}{twice the absolute value of maximized log-likelihood.}
\item{aic}{A version of Akaike's An Information Criterion, minus twice the
maximized log-likelihood plus twice the number of parameters, computed by
the \code{aic} component of the family. For the binomial model, the dispersion
is fixed at one and the number of parameters is the number of coefficients.}
\item{null.deviance}{The deviance for the null model, comparable with
\code{deviance}. The null model will only include an intercept if there is
one in the model.}
\item{df.residual}{the residual degrees of freedom.}
\item{df.null}{the residual degrees of freedom for the null model.}
\item{response}{the response vector used in the mode.l}
\item{vcov}{the unscaled (\code{dispersion = 1}) estimated covariance matrix
of the estimated coefficients.}
\item{vce}{the type of information matrix applied.}
\item{call}{the matched call.}
\item{na.action}{(where relevant) information returned by \code{stats::model.frame}
on the special handling of \code{NA}.}
\item{contrasts}{(where relevant) the contrasts used.}
\item{formula}{the formula supplied.}
\item{factor}{the order of factors used in the response variable.}
\item{bvector}{the matrix of boundary vectors.}
\item{bv}{logical. Determines whether the model has boundary vectors.}
}
\description{
If the maximum likelihood (ML) solution lies on the boundary of the
             parameter space in log binomial model, a special method is needed
             since the standard fitting algorithm may meet numerical difficulties.
             Exact method can overcome the difficulties and address the ML solution
             when it lies on the boundary of the parameter space.\code{lbm}
             implemented the exact method to address the ML solution in the log binomial model.
}
\details{
A typical predictor has the form \code{response ~ terms} where
    response is the (numeric) response vector and terms is a series of
    terms which specifies a linear predictor for response. A terms
    specification of the form \code{first + second} indicates all the
    terms in first together with all the terms in second with any
    duplicates removed.
    A specification of the form \code{first:second} indicates the set of
    terms obtained by taking the interactions of all terms in first with
    all terms in second. The specification \code{first*second} indicates
    the cross of first and second. This is the same as
    \code{first + second + first:second}.
    The terms in the formula will be re-ordered so that main effects come
    first, followed by the interactions, all second-order, all third-order
    and so on: to avoid this pass a terms object as the formula.
}
\examples{
## Two examples are from Petersen, M. R. & Deddens, J. A. (2010).

## Example 1.
x<-c(1:10)
y<-c(0,0,0,0,1,0,1,1,1,1)
data<-data.frame(x,y)
a<-lbm(formula=y~x,data=data,vce="eim")

## Example 2.
x1<-c(1:11)
x2<-x1^2
y<-c(10,6,4,3,3,2,3,3,4,6,10)
dat<-cbind(x1,x2,y)
dat1<-apply(dat, 1, function(t) {
  temp<-data.frame(x1=rep(t[1],10),x2=rep(t[2],10),y=0)
  temp$y[1:t[3]]<-1
  return(temp)
})
data<-do.call(rbind, dat1)
a<-lbm(formula=y~x1+x2,data=data)
summary(a)

}
\references{
Petersen, M. R. & Deddens, J. A. (2010). Maximum likelihood estimation
    of the log-binomial model. \emph{Communications in Statistics - Theory
    and Methods}, 39: 5, 874 - 883.
}
\seealso{
\code{glm}, \code{lm}.
}
\keyword{binomial}
\keyword{boundary}
\keyword{convergence}
\keyword{log}
\keyword{model}
\keyword{ratio/relative}
\keyword{risk}
