% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{lcarsPage}
\alias{lcarsPage}
\title{LCARS Shiny UI}
\usage{
lcarsPage(
  ...,
  title = NULL,
  force_uppercase = TRUE,
  label_uppercase = TRUE,
  lcars_font_headers = TRUE,
  lcars_font_labels = TRUE,
  lcars_font_text = TRUE
)
}
\arguments{
\item{...}{The contents of the document body.}

\item{title}{The browser window title (defaults to the host URL of the page).}

\item{force_uppercase}{logical, see details.}

\item{label_uppercase}{logical, also make widget labels uppercase globally.}

\item{lcars_font_headers}{use LCARS-style font family for major heading
text. See details.}

\item{lcars_font_labels}{use LCARS-style font family for LCARS widget
labels/titles.}

\item{lcars_font_text}{use LCARS-style font family for general text
(paragraphs, lists, etc.).}
}
\value{
A UI definition that can be passed to the shinyUI function.
}
\description{
Create a Shiny UI page with an LCARS theme.
}
\details{
The LCARS style heavily emphasizes uppercase text. Set \code{force_uppercase = TRUE}
to force this standard via CSS. This does not make everything uppercase;
things like input labels are left alone (use \code{label_uppercase = TRUE}).
However, text in general in uppercased.

Set these to \code{FALSE} if you need control over casing. This allows sensible
judgment over how to balance the tension between making something that
conforms well to the familiar LCARS aesthetic and making something that
communicates information with a lower cognitive load for the user.
Similarly, set \verb{lcars_font*} arguments to \code{FALSE} to use a more readable sans
serif font as desired. See examples for recommendations.
}
\examples{
\donttest{
# Recommended settings
# (results stored in x and not printed due to length)

# for a more standard LCARS style: default settings.
x <- lcarsPage()

# for a more readable style: less uppercase, switch to sans font
x <- lcarsPage(force_uppercase = FALSE, label_uppercase = FALSE,
  lcars_font_labels = FALSE, lcars_font_text = FALSE)
}
}
