% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{fitted.lcc}
\alias{fitted.lcc}
\title{Extract Fitted Values from an \code{lcc} Object}
\usage{
\method{fitted}{lcc}(object, type = "lcc", digits = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{lcc}, representing a fitted longitudinal
concordance correlation model.}

\item{type}{The type of fitted values to extract: "lcc" for longitudinal
concordance correlation, "lpc" for longitudinal Pearson correlation,
or "la" for longitudinal accuracy. Defaults to "lcc".}

\item{digits}{Minimum number of significant digits to be printed.
Default is \code{NULL}, which uses the default precision.}

\item{...}{Additional arguments (currently not used).}
}
\value{
The function prints the fitted values and returns them as a data frame.
}
\description{
Extracts and prints the fitted values from an object of class
  \code{lcc}, as returned by modeling functions. The function allows selection
  of different types of fitted values based on longitudinal data analysis.
}
\examples{
data(hue)
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2,
           components = TRUE)
fitted(fm1)
fitted(fm1, type = "lpc")
fitted(fm1, type = "la")

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link[lcc]{summary.lcc}},
  \code{\link[lcc]{lccPlot}}
}
