% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_marks.R
\name{predict_marks}
\alias{predict_marks}
\title{Predict values from the mark distribution}
\usage{
predict_marks(
  sim_realization,
  raster_list = NULL,
  scaled_rasters = FALSE,
  mark_model = NULL,
  xy_bounds = NULL,
  include_comp_inds = FALSE,
  competition_radius = 15,
  correction = "none"
)
}
\arguments{
\item{sim_realization}{a data frame containing a thinned or unthinned realization from \code{simulate_sc}.}

\item{raster_list}{a list of raster objects.}

\item{scaled_rasters}{`TRUE` or `FALSE` indicating whether the rasters have been scaled.}

\item{mark_model}{a model object (typically from \code{train_mark_model}).}

\item{xy_bounds}{a vector of domain bounds (2 for x, 2 for y).}

\item{include_comp_inds}{`TRUE` or `FALSE` indicating whether to generate and use competition indices as covariates.}

\item{competition_radius}{distance for competition radius if \code{include_comp_inds} is `TRUE`.}

\item{correction}{type of correction to apply ("none" or "toroidal").}
}
\value{
a vector of predicted mark values.
}
\description{
Predict values from the mark distribution
}
\examples{
# Simulate a realization
generating_parameters <- c(2, 8, .02, 2.5, 3, 1, 2.5, .2)
M_n <- matrix(c(10, 14), ncol = 1)
generated_locs <- simulate_sc(
  t_min = 0,
  t_max = 1,
  sc_params = generating_parameters,
  anchor_point = M_n,
  xy_bounds = c(0, 25, 0, 25)
)

# Load the raster files
raster_paths <- list.files(system.file("extdata", package = "ldmppr"),
  pattern = "\\\\.tif$", full.names = TRUE
)
rasters <- lapply(raster_paths, terra::rast)

# Scale the rasters
scaled_raster_list <- scale_rasters(rasters)

# Load the example mark model
file_path <- system.file("extdata", "example_mark_model.rds", package = "ldmppr")
example_mark_model <- readRDS(file_path)

# Unbundle the model
mark_model <- bundle::unbundle(example_mark_model)

# Predict the mark values
predict_marks(
  sim_realization = generated_locs$thinned,
  raster_list = scaled_raster_list,
  scaled_rasters = TRUE,
  mark_model = mark_model,
  xy_bounds = c(0, 25, 0, 25),
  include_comp_inds = TRUE,
  competition_radius = 10,
  correction = "none"
)

}
