% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cost_corridor.R
\name{create_cost_corridor}
\alias{create_cost_corridor}
\title{creates a cost corridor}
\usage{
create_cost_corridor(x, origin, destination, rescale = FALSE)
}
\arguments{
\item{x}{\code{SpatRaster}}

\item{origin}{\code{sf} 'POINT' or 'MULTIPOINT', \code{SpatVector}, \code{data.frame} or \code{matrix} containing the origin coordinates. Only the first row of the supplied object is used as the origin.}

\item{destination}{\code{sf} 'POINT' or 'MULTIPOINT', \code{SpatVector}, \code{data.frame} or \code{matrix} containing the destination coordinates.  Only the first row of the supplied object is used as the destination.}

\item{rescale}{\code{logical}. if TRUE, values scaled to between 0 and 1. FALSE (default)}
}
\value{
\code{SpatRaster}
}
\description{
Combines and averages the accumulated cost surfaces from origin-to-destination and destination-to-origin to identify areas of preferential movement that takes into account both directions of movement
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(839769, 4199443)),
sf::st_point(c(1038608, 4100024)),
crs = terra::crs(r)))

cc <- create_cost_corridor(x = slope_cs, origin = locs[1,], destination = locs[2,], rescale = TRUE)
}
\author{
Joseph Lewis
}
