% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{stickchart}
\alias{stickchart}
\title{Stick chart}
\usage{
stickchart(
  x,
  freq = "a",
  bg = TRUE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  grids = grid(col = "white"),
  bgcol = "gray",
  bgborder = NA,
  posx1 = 0,
  posx2 = 0,
  xang = 0,
  labels = NULL,
  lcol = "black",
  pcol = lcol,
  pty = 19,
  pwd = 3,
  lty = 1,
  lwd = 2,
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{freq}{Character argument. Type of frequency with options: \code{"a"} (absolute and default), \code{"r"} relative and \code{"p"} percentage.}

\item{bg}{Logical argument. Default is \code{TRUE}, it displays the background, and \code{bg = FALSE} otherwise.}

\item{main}{Insert the plot title. The default is \code{NULL}.}

\item{xlab}{Insert the title of the x-axis graphic label. The default is \code{NULL}.}

\item{ylab}{Insert the title of the y-axis graphic label. The default is \code{NULL}.}

\item{grids}{Insert grids to plot. The default is \code{grid(col = "white")}.}

\item{bgcol}{Insert the background color. This argument is only valid when \code{bg = TRUE}. The default is \code{bgcol="gray"}.}

\item{bgborder}{Insert the background border color. This argument is only valid when \code{bg = TRUE}. The default is bgborder = NA.}

\item{posx1}{Numeric argument.Distance of the labels (horizontal) in relation to the x axis.}

\item{posx2}{Numeric argument.Distance of the labels (vertical) in relation to the x axis.}

\item{xang}{Numeric argument.Angle of the labels in relation to the x axis}

\item{labels}{Character argument. Labels name vector.}

\item{lcol}{Line color. The default is \code{lcol = "black"}.}

\item{pcol}{Point color. The default is \code{pcol = lcol}.}

\item{pty}{Point type. The default is  \code{pty = 19}.}

\item{pwd}{Point width. The default is  \code{pwd = 3}.}

\item{lty}{Line type. The default is  \code{lty = 2}.}

\item{lwd}{Line width. The default is  \code{lwd = 2}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The result of \code{stickchart()} is \code{x} object.
}
\description{
Stick chart for discrete data
}
\examples{
library(leem)
# Example 1
rbinom(30, 10, 0.4) |>
  new_leem() |>
  tabfreq() |>
  stickchart()
# Example 2
school <- rep(c("high", "university", "basic"), 3:5)
sample(school, 30, TRUE) |>
  new_leem() |>
  tabfreq(ordered = c("basic", "high", "university")) |>
  stickchart(xang = 15, posx2 = -0.5)
}
