% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{miniMod}
\alias{miniMod}
\title{Minimize lefkoMod Object by Conversion to vrm_input Object}
\usage{
miniMod(
  lMod,
  hfv_data = NULL,
  stageframe = NULL,
  all_years = NULL,
  all_patches = NULL,
  all_groups = NULL,
  all_indcova = NULL,
  all_indcovb = NULL,
  all_indcovc = NULL
)
}
\arguments{
\item{lMod}{A \code{lefkoMod} object.}

\item{hfv_data}{The \code{hfv_data} formatted data frame used to develop
object \code{lMod}.}

\item{stageframe}{The stageframe used to develop object \code{lMod}.}

\item{all_years}{A vector giving the times / years used to develop object
\code{lMod}, exactly as used in the latter. Only needed if object
\code{hfv_data} not provided.}

\item{all_patches}{A vector giving the patch names used to develop object
\code{lMod}, exactly as used in the latter. Only needed if object
\code{hfv_data} not provided.}

\item{all_groups}{A vector giving the stage groups used to develop object
\code{lMod}, exactly as used in the latter. Only needed if object
\code{stageframe} not provided.}

\item{all_indcova}{The name of individual covariate a if quantitative and
non-categorical, or of the categories used if the covariate is a factor
variable. Only needed if object \code{hfv_data} not provided but individual
covariates used in vital rate models.}

\item{all_indcovb}{The name of individual covariate a if quantitative and
non-categorical, or of the categories used if the cvoariate is a factor
variable. Only needed if object \code{hfv_data} not provided but individual
covariates used in vital rate models.}

\item{all_indcovc}{The name of individual covariate a if quantitative and
non-categorical, or of the categories used if the covariate is a factor
variable. Only needed if object \code{hfv_data} not provided but individual
covariates used in vital rate models.}
}
\value{
An object of class \code{vrm_input}. See function
\code{\link{vrm_import}()} for details.
}
\description{
This function takes a \code{lefkoMod} object, which consists of vital rate
models, their associated \code{dredge} model tables, and related metadata,
and converts them to minimal data frame lists useable in MPM creation and
projection. The main advantage to using this approach is in memory savings.
}
\examples{
\donttest{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec, 
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9, 
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988", 
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathmodelsln3 <- modelsearch(lathvertln, historical = TRUE, 
  approach = "mixed", suite = "main", 
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson", 
  indiv = "individ", patch = "patchid", year = "year2",
  year.as.random = TRUE, patch.as.random = TRUE, show.model.tables = TRUE,
  quiet = "partial")

lathmodels_mini <- miniMod(lathmodelsln3, hfv_data = lathvertln,
  stageframe = lathframeln)
lathmodels_mini
}

}
