% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{Appender}
\alias{Appender}
\alias{Appenders}
\title{Appenders}
\description{
Appenders are attached to \link{Loggers} and manage the output of the
\link{LogEvents} to a destination - such as the console or a text file. An
Appender has a single \link{Layout} that tells it how to format the LogEvent. For
details please refer to the documentations of the specific Appenders.

Additional Appenders that support a wide range of output destinations -
such as databases, email, push-notifications or Linux syslog - are available
from the package \href{https://github.com/s-fleck/lgrExtra}{lgrExtra}.

\strong{NOTE}: This is an \emph{abstract class}. Abstract classes cannot be instantiated
directly, but are exported for package developers that want to extend lgr -
for example by creating their own \link[=Appender]{Appenders} or \link[=Layout]{Layouts}.
Please refer to the \emph{see also} section for actual implementations of this
class.
}
\seealso{
Other abstract classes: 
\code{\link{AppenderMemory}},
\code{\link{AppenderTable}},
\code{\link{Filterable}}

Other Appenders: 
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFile}},
\code{\link{AppenderFileRotating}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotatingTime}},
\code{\link{AppenderTable}}
}
\concept{Appenders}
\concept{abstract classes}
\keyword{internal}
\section{Super class}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{Appender}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{destination}}{The output destination of the \code{Appender} in human-readable form. This
is mainly used when printing information about the Appender itself.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Appender-new}{\code{Appender$new()}}
\item \href{#method-Appender-append}{\code{Appender$append()}}
\item \href{#method-Appender-set_threshold}{\code{Appender$set_threshold()}}
\item \href{#method-Appender-set_layout}{\code{Appender$set_layout()}}
\item \href{#method-Appender-format}{\code{Appender$format()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Appender-new"></a>}}
\if{latex}{\out{\hypertarget{method-Appender-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Appender$new(layout = Layout$new(), threshold = NA_integer_)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Appender-append"></a>}}
\if{latex}{\out{\hypertarget{method-Appender-append}{}}}
\subsection{Method \code{append()}}{
Process a \link{LogEvent} \code{event}. This method is usually not
called by the user, but invoked by a \link{Logger}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Appender$append(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Appender-set_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-Appender-set_threshold}{}}}
\subsection{Method \code{set_threshold()}}{
Set the minimum log level that triggers this Appender. See
\code{\link[=threshold]{threshold()}} for examples
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Appender$set_threshold(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{\code{character} or \code{integer} scalar log level. See \link{log_levels}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Appender-set_layout"></a>}}
\if{latex}{\out{\hypertarget{method-Appender-set_layout}{}}}
\subsection{Method \code{set_layout()}}{
Set the \code{Layout} that this Appender will use for formatting
\code{LogEvents}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Appender$set_layout(layout)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Appender-format"></a>}}
\if{latex}{\out{\hypertarget{method-Appender-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Appender$format(color = FALSE, ...)}\if{html}{\out{</div>}}
}

}
}
