% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_intersect.R, R/catalog_select.R
\name{catalog_intersect}
\alias{catalog_intersect}
\alias{catalog_subset}
\alias{catalog_select}
\title{Subset a LAScatalog}
\usage{
catalog_intersect(
  ctg,
  y,
  ...,
  subset = c("subset", "flag_unprocessed", "flag_processed")
)

catalog_select(
  ctg,
  mapview = TRUE,
  subset = c("subset", "flag_unprocessed", "flag_processed")
)
}
\arguments{
\item{ctg}{A \link[=LAScatalog-class]{LAScatalog}}

\item{y}{`bbox`, `sf`, `sfc`, `Extent`, `Raster*`, `Spatial*` objects}

\item{...}{ignored}

\item{subset}{character. By default it subsets the collection It is also possible to flag
the files to maintain the collection as a whole but process only a subset of its content.
\code{flag_unprocessed} flags the files that will not be processed.
\code{flag_processed} flags the files that will be processed.}

\item{mapview}{logical. If \code{FALSE}, use R base plot instead of mapview (no pan, no zoom, see
also \link[=plot]{plot})}
}
\value{
A LAScatalog object
}
\description{
Subset a LAScatalog interactively using the mouse. Subset a LAScatalog with a spatial object to
keep only the tiles of interest. It can be used to select tiles of interest that encompass spatial
objects.
}
\examples{
\dontrun{
ctg = readLAScatalog("<Path to a folder containing a set of .las files>")
new_ctg = catalog_select(ctg)
}
}
