% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{aba_plot}
\alias{aba_plot}
\title{Plots observed VS values predicted in leave one out cross validation of an
\code{\link{aba_build_model}}}
\usage{
aba_plot(aba_model, disp_text = F, col = NULL, add_legend = NULL, ...)
}
\arguments{
\item{aba_model}{list. as returned by \code{\link{aba_build_model}}}

\item{disp_text}{boolean. indicates if points should be labeled with id}

\item{col}{color to be passed to \code{\link[graphics]{plot}}, default is
black for single models, depends on stratum in stratified models}

\item{add_legend}{list. parameters to be passed to \code{\link[graphics]{legend}}. In case of a stratified model, legend is automatically set up.}

\item{...}{other parameters to be passed to \code{\link[graphics]{plot}},
\code{xlab} and \code{ylab} are automatically added}
}
\value{
nothing
}
\description{
Plots observed VS values predicted in leave one out cross validation of an
\code{\link{aba_build_model}}
}
\examples{
# load Quatre Montagnes dataset
data(quatre_montagnes)
# build ABA model for basal area, with three metrics as predictors
model_aba <- aba_build_model(quatre_montagnes$G_m2_ha,
                             quatre_montagnes[, c("zpcum8", "ipcumzq70", "p_hmin")],
  transform = "log", nmax = 2
)

# plot field values VS predictions in cross-validation
aba_plot(model_aba, main = "Basal area")
}
