% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_summary.R
\name{summary.lyl_ci}
\alias{summary.lyl_ci}
\title{Summarize Life Years Lost with confidence intervals}
\usage{
\method{summary}{lyl_ci}(
  object,
  decimals = 2,
  level = 0.95,
  weights = NA,
  difference = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{lyl_ci} (obtained with function \code{lyl_ci}).}

\item{decimals}{Number of decimals to be reported (default is 2).}

\item{level}{Confidence level (default is 0.95 for 95\% confidence intervals)}

\item{weights}{Vector with age distribution of disease/condition onset to be used when Life Years Lost are estimated
over a range of ages (with \code{lyl_range} function). If weights are not provided (dafault is \code{weights = NA}),
then the differences in Life Years Lost at each age is provided. If weights are provided, then a weighted average is provided.}

\item{difference}{Parameter automatically created by the package.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A table with the summary of the results.
}
\description{
\code{summary} for objects of class \code{lyl_ci} summarizes Life Years Lost
at one specific age or over a range of different ages, including bootstrapped
confidence intervals
}
\examples{
# Load simulated data as example
data(simu_data)

# Estimate remaining life expectancy and Life Years
# Lost after age 45 years and before age 95 years
lyl_estimation <- lyl(data = simu_data, t = age_death, status = death,
                      age_specific = 45, tau = 95)

# Calculate bootstrapped confidence interval (3 iterations to test; more are necessary)
lyl_estimation_ci <- lyl_ci(lyl_estimation, niter = 3)
summary(lyl_estimation_ci)

\donttest{
# Estimate remaining life expectancy and Life Years
# Lost after each age from 0 to 94 years and before age 95 years
lyl_estimation2 <- lyl_range(data = simu_data, t = age_death, status = death,
                             age_begin = 0, age_end = 94, tau = 95)

# Calculate bootstrapped confidence interval (3 iterations to test; more are necessary)
lyl_estimation_ci2 <- lyl_ci(lyl_estimation2, niter = 3)
summary(lyl_estimation_ci2, weights = simu_data$age_disease)
}
}
\references{
\itemize{
    \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition.
    \emph{PLoS ONE}. 2020;15(3):e0228073.}
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl}} for estimation of Life Years Lost at one specific age.}
    \item{\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.}
    \item{\code{\link{lyl_ci}} to estimate bootstrapped confidence intervals.}
}
}
