% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_mu_vec}
\alias{get_mu_vec}
\title{Calculate Exponential of Linear Combinations}
\usage{
get_mu_vec(x12, beta)
}
\arguments{
\item{x12}{NumericMatrix representing a matrix of predictors, where each row corresponds
to an observation and columns correspond to different predictor variables (e.g., weeks and weekends).}

\item{beta}{NumericVector of coefficients corresponding to the predictors in `x12`.
This should include coefficients for both weekly effects and potentially an additional
coefficient for weekends.}
}
\value{
NumericVector where each element is the exponential of the linear combination
        of the predictors and coefficients for a given observation. This vector represents
        the model-estimated mean values for each observation.
}
\description{
Computes the exponential of linear combinations of beta coefficients and a matrix
of predictors, typically used in Poisson or logistic regression models for estimating
rates or probabilities. This function specifically handles the exponential transformation,
which is commonly used to ensure that rates or probabilities are non-negative.
}
\details{
The function multiplies the matrix `x12` by the vector `beta` to get the linear predictors,
         then applies the exponential function to convert these linear predictors to a scale
         suitable for models where the response variable is a count or probability.
         This is a critical step in generalized linear models where the link function is
         the natural logarithm.
}
\examples{
# Assuming x12 is a matrix with 10 observations and 3 predictors
# and beta is a vector of 3 coefficients
x12 <- matrix(rnorm(30), ncol=3)
beta <- c(0.1, -0.2, 0.05)
get_mu_vec(x12, beta)
}
