% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oos_realized_forc_general.R
\name{oos_realized_forc_general}
\alias{oos_realized_forc_general}
\title{Out-of-sample general model forecast conditioned on realized values}
\usage{
oos_realized_forc_general(
  model_function,
  prediction_function,
  data,
  realized,
  h_ahead,
  estimation_end,
  time_vec,
  estimation_window = NULL
)
}
\arguments{
\item{model_function}{Function that estimates a model using the \code{data} input.}

\item{prediction_function}{Function that generates model predictions using \code{model_function}
and \code{data} as inputs.}

\item{data}{Input data for estimating the model.}

\item{realized}{Vector of realized values of the dependent variable equal in length
to the data in \code{data}.}

\item{h_ahead}{Integer representing the number of periods ahead that is being
forecasted.}

\item{estimation_end}{Value of any class representing when to end the initial
coefficient estimation period and begin forecasting.}

\item{time_vec}{Vector of any class that represents time and is equal in length to
the length of \code{realized} and \code{data}.}

\item{estimation_window}{Integer representing the number of past periods
that the linear model should be estimated over in each period.}
}
\value{
\code{\link{Forecast}} object that contains the out-of-sample
forecast.
}
\description{
\code{oos_realized_forc} takes a model function, a prediction function, input
data for estimating the model, realized values of the dependent variable, an
integer number of periods ahead to forecast, a period to end the initial coefficient
estimation and begin forecasting, a vector of time data associated with the model,
and an optional integer number of past periods to estimate the model over. The
model is originally estimated using the input data and model function with data
up to \code{estimation_end} minus the the number of periods specified in \code{estimation_window}.
If \code{estimation_window} is left \code{NULL} then the model is estimated with all
available data up to \code{estimation_end}. Model parameters are then combined with realized
values of the input data \code{h_ahead} periods ahead to generate an \code{h_ahead} period
ahead forecast. This process is iteratively repeated for each period after \code{estimation_end}
with model parameters updating in each period. Returns an out-of-sample forecast
conditional on realized values that \strong{would not} have been available at the forecast origin.
Tests the out-of-sample performance of a model had it been conditioned on perfect information.
}
\examples{

date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30", "2012-09-30", "2012-12-31",
                  "2013-03-31", "2013-06-30", "2013-09-30", "2013-12-31"))
y  <- c(1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0)
x1 <- c(8.22, 3.86, 4.27, 3.37, 5.88, 3.34, 2.92, 1.80, 3.30, 7.17, 3.22, 3.86, 
    4.27, 3.37, 5.88, 3.34)
x2 <- c(4.03, 2.46, 2.04, 2.44, 6.09, 2.91, 1.68, 2.91, 3.87, 1.63, 4.03, 2.46, 
    2.04, 2.44, 6.09, 2.91)
dataLogit <- data.frame(date, y, x1, x2)

forc <- oos_realized_forc_general(
    model_function = function(data) {glm(y ~ x1 + x2, data = data, family = binomial)},
    prediction_function = function(model_function, data) {
        as.vector(predict(model_function, data, type = "response"))
    }, 
    data = dataLogit,
    realized = dataLogit$y,
    h_ahead = 2L,
    estimation_end = as.Date("2012-06-30"),
    time_vec = dataLogit$date,
    estimation_window = NULL
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
