% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.clmdu.R
\name{bootstrap.clmdu}
\alias{bootstrap.clmdu}
\title{Bootstrap procedure for Cumulative Logistic (Restricted) MDU}
\usage{
bootstrap.clmdu(object, Bsamples = 1000, myseed = 1)
}
\arguments{
\item{object}{An output object from clmdu}

\item{Bsamples}{Number of Bootstrap samples to take}

\item{myseed}{A seed number to make the bootstrap reproducible}
}
\value{
BBdf Bootstrap estimates of B

BVdf Bootstrap estimates of V
}
\description{
Bootstrap procedure for Cumulative Logistic (Restricted) MDU
}
\examples{
\dontrun{
data(dataExample_lmdu)
Y = as.matrix(dataExample_clmdu[ , 1:8])
X = as.matrix(dataExample_clmdu[ , 9:13])
output2 = clmdu(Y = Y, X = X, S = 2)
boot.output = bootstrap.lmdu(output2, Bsamples = 100)
plot(boot.output)
}

}
