% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lpca.R
\name{predict.lpca}
\alias{predict.lpca}
\title{The function predict.lpca makes predictions for a test/validation set
 based on a fitted lrrr model (lpca with X)}
\usage{
\method{predict}{lpca}(object, newX, newY = NULL, ...)
}
\arguments{
\item{object}{An \code{lpca} object}

\item{newX}{An N by P matrix with predictor variables for a test/validation set}

\item{newY}{An N by R matrix with response variables  for a test/validation set}

\item{\dots}{additional arguments to be passed.}
}
\value{
This function returns an object of the class \code{lpca} with components:
\item{theta}{Predicted canonical values for the test set}
\item{Yhat}{Predicted values for the test set}
\item{devr}{Estimated prediction deviance for separate responses}
\item{devtot}{Estimated prediction deviance for all responses}
\item{Brier.r}{Estimated Brier score for separate responses}
\item{Brier}{Estimated Brier score for all responses}
}
\description{
The function predict.lpca makes predictions for a test/validation set
 based on a fitted lrrr model (lpca with X)
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[-c(1:20) , 1:8])
X = as.matrix(dataExample_lpca[-c(1:20) , 9:13])
newY = as.matrix(dataExample_lpca[1:20 , 1:8])
newX = as.matrix(dataExample_lpca[1:20 , 9:13])
# supervised
output = lpca(Y = Y, X = X, S = 2)
preds = predict(output, newX = newX, newY = newY)
}

}
