% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mlr.R
\name{predict.mlr}
\alias{predict.mlr}
\title{The function predict.mlr makes predictions for a test/validation set
 based on a fitted mlr model}
\usage{
\method{predict}{mlr}(object, newX, ...)
}
\arguments{
\item{object}{An \code{mlr} object}

\item{newX}{An N by P matrix with predictor variables for a test/validation set}

\item{\dots}{additional arguments to be passed.}
}
\value{
This function returns an object of the class \code{p.mlr} with components:
\item{Ghat}{Predicted values (probabilities) for the test set}
}
\description{
The function predict.mlr makes predictions for a test/validation set
 based on a fitted mlr model
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output = mlr(y = y, X = X, base = 1)
preds = predict(output, newX = X[1:4, ])
}


}
