#' Simulated Data for Smoothing Spline Curve Fitting
#'
#' @description
#' Simulated dataset to demonstrate smoothing spline curve fitting with
#' \code{\link{smspline}} and \code{\link[nlme]{lme}}. The data consists of 100
#' observations simulated around the curve \eqn{y = 10 - 6 \exp(-4t/100)} with
#' independent normal random errors (standard deviation = 1).
#'
#' @format A data frame with 100 rows and 3 variables:
#' \describe{
#'   \item{time}{Time covariate.}
#'   \item{y}{Simulated response values.}
#'   \item{y.true}{True response values.}
#' }
#'
#' @source Generated by Rod Ball for the \code{lmeSplines} package.
#'
#' @examples
#' data(smSplineEx1)
#' str(smSplineEx1)
#' plot(smSplineEx1$time, smSplineEx1$y, main = "Simulated Data", xlab = "Time", ylab = "y")
#' lines(smSplineEx1$time, smSplineEx1$y.true, col = "blue")
#'
#' @docType data
#' @keywords datasets
#' @name smSplineEx1
"smSplineEx1"
