% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIQML.fit.R
\name{ZIQML.fit}
\alias{ZIQML.fit}
\title{Group and covariate effects on lncRNA counts by Generalized Linear Model}
\usage{
ZIQML.fit(edata, design.matrix, link = "log")
}
\arguments{
\item{edata}{Normalized counts matrix with genes in rows and samples in columns.}

\item{design.matrix}{Design matrix for groups and covariates, generated by model.matrix().}

\item{link}{Link function for the generalized linear model and likelihood function,either 'log' or 'identity'. The default is 'log'.}
}
\value{
\item{Estimates}{Estimated group effect on gene expression by zero-inflated exponential quasi maximum likelihood (ZIQML) estimator.}
   \item{logLikelihood}{The value of zero-inflated quasi likelihood.} 
   \item{edata}{lncRNA counts or expression matrix.} 
   \item{design.matrix}{The design matrix of groups and covariates.} 
   \item{link}{The specified link function.}
}
\description{
ZIQML.fit estimates the group effect on gene expression using zero-inflated exponential quasi likelihood.
}
\examples{

data('hnsc.edata','design') 
# 'hnsc.edata' contains FPKM of 1000 lncRNA genes and 80 samples 
# 'design' is the design matrix for tissue and batch.

# For the first 100 genes  
# Fit GLM by ZIQML with logarithmic link function                                      
fit.log=ZIQML.fit(edata=hnsc.edata[1:100,],design.matrix=design,link='log') 

# Fit GLM by ZIQML with identity link function
fit.identity=ZIQML.fit(edata=hnsc.edata[1:100,],design.matrix=design,link='identity') 

}
