% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shaper_lin.R
\name{lslin}
\alias{lslin}
\title{Linear Method for Matching Peak and Load Factor}
\usage{
lslin(x, target_max = 10000, target_lf = 0.7)
}
\arguments{
\item{x}{A numeric array, representing reference load shape.
All values must be strictly positive containing no \code{NA}(s).
The length of \code{x}
must be greater > 167.}

\item{target_max}{Target peak value of resultant load shape, must
be > 0.}

\item{target_lf}{Target load factor of resultant load shape, must be
numeric in between 0 and 1 (exclusive).}
}
\value{
A list of class \code{"lslin"}, having following elements:
\itemize{

\item{\code{df}: A data frame. See "Details".}
\item{\code{beta}: Slope of the linearly increasing/decreasing multipliers.
See "Details".}

\item{\code{max_mult}: Maximum of the multipliers.}
\item{\code{min_mult}: Minimum of the multipliers.}
\item{\code{base_load_factor}: Load factor of the reference load
shape \code{x}.}

\item{\code{target_load_factor}: Target load factor.}
\item{\code{derived_load_factor}: Load factor of the derived load shape
(\code{object$df$y}).}
\item{\code{base_max}: Peak value of the base load shape, \code{x}}
\item{\code{target_max}: Target peak value of the new load shape.}
\item{\code{derived_max}: Peak value of the derived load shape
 (\code{object$df$y}) }

\item{\code{base_min}: Minimum value of the base load shape, \code{x}}
\item{\code{derived_min}: Minimum value of the derived load shape
 (\code{object$df$y}) }

\item{\code{dec_flag}: A logical flag  stating
whether the multipliers resulted in strictly decreasing values.
\code{TRUE} indicates the order was not preserved.
Only applicable for \code{target_max} > \code{base_max}.
See "Details".}
\item{\code{lf_flag}: A logical flag indicating if the
load factor of the derived shape differs from the target
by more than 1\%.
}
\item{\code{min_pu_flag}: A logical flag indicating existence of
negative values in the derived load shape. \code{TRUE} indicates
the existence of negative values.
Only applicable for \code{target_max} < \code{base_max}.
See "Details".}


}
}
\description{
\code{lslin} applies linear method to a reference load
shape to match the peak and load factor to target values. See "Details"
for the algorithm.
}
\details{
The algorithm first evaluates the load factor of the
reference load shape \code{x}, which is
defined by the ratio of average to peak value. If the target load
factor is greater than reference level, then all base
values are multiplied by a number \code{ > 1}. If the target
load factor is less than reference level, then all base values are
multiplied by a number \code{ < 1}. The multipliers increase/decrease
linearly and are applied to the based values after ordered.


If \eqn{x'} is the ordered version of \eqn{x}, then \eqn{x'_{i}}
will be multiplied by \eqn{1-(i-1)*\beta}, where \eqn{\beta} is
a constant calculated as:


\deqn{\beta = \frac{\sum_{i=1}^n x'_{i} - target\ load\ factor }
{\sum_{i=1}^n x'_{i}(i-1)}}

The load factor of the derived series matches the target.
For \eqn{target < base}, \eqn{\beta} is positive and vice-versa.

The algorithm attempts hard to match the load factor of the derived
load shape to the base load factor. \eqn{\beta} becomes large in
magnitude for large difference of base and target load factor.
In case \eqn{\beta > 1}, it is possible to get negative
multipliers which force the values to be negative. This particular
situation can occur when target load factor is significantly smaller
than the base load factor.

If the target load factor is much bigger than the base
load factor, one/both of the followings can occur:
\itemize{
 \item As a  linearly increasing function is multiplied
 by a  decreasing function (\eqn{x'}), it is possible
 that the maximum of the product can exceed the maximum value
 of the base  (\eqn{x'}), resulting in a different load factor.

 \item As a  linearly increasing function is multiplied
 by a  decreasing function (\eqn{x'}), it is possible
 that the product is not strictly decreasing. The product
 array is re-ordered to produce the final values.
 }



The return object contains a data frame \code{df}, having the
following columns:
\itemize{

\item{\code{x_index}: An index given to the original load
shape \code{x}, starting from 1 to \code{length(x)}}.

\item{\code{x}: The original array \code{x}, unaltered.}

\item{\code{x_rank}: The rank of the data points of the
given array \code{x}, from 1 for the peak to
\code{length(x)} for the lowest value.}

\item{\code{x_ordered}: Sorted \code{x} (largest to smallest).}
\item{\code{x_pu}: Per unit \code{x}, derived by diving \code{x}
by \code{max(x)}}.

\item{\code{x_ordered_pu}: Per unit \code{x}, sorted from largest
to smallest.}


\item{\code{mult}: Derived multipliers, would be applied to
sorted per unit \code{x}.}


\item{\code{y_ordered_pu}: Product of per unit sorted \code{x}
and \code{mult}.}


\item{\code{y_ordered_pu2}: \code{y_ordered_pu}, sorted again,
in case \code{y_ordered_pu} does not become decreasing.}


\item{\code{y_pu}: Resultant load shape in per unit. This is
derived by re-ordering \code{y_ordered_pu2} with respect to their
original rank.}


\item{\code{y}: Resultant load shape. This is derived by
multiplying \code{y_pu} by \code{taget_max} / \code{base_max}
}



}
}
\examples{
loads <- ercot[ercot$Year == 2019, ]$COAST
plot(loads, type = "l")
linear_loadshape <- lslin(loads, target_lf = 0.50)
summary(linear_loadshape)
#-------------------------------------
loads2 <- ercot[ercot$Year == 2020, ]$ERCOT
plot(loads2, type = "l")
linear_loadshape2 <- lslin(loads2, target_lf = 0.7)
summary(linear_loadshape2)#'
#-------------------------------------
loads3 <- ercot[ercot$Year == 2020, ]$ERCOT
plot(loads3, type = "l")
linear_loadshape3 <- lslin(loads3, target_lf = 0.95)
summary(linear_loadshape3)
#-------------------------------------
loads4 <- ercot[ercot$Year == 2020, ]$SCENT
plot(loads3, type = "l")
linear_loadshape4 <- lslin(loads4, target_lf = 0.3)
summary(linear_loadshape4)



}
\seealso{
\code{\link{lslog}},
\code{\link{print.lslin}},
\code{\link{summary.lslin}},
\code{\link{plot.lslin}},
\code{\link{lscore}}
}
