% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{account_archive}
\alias{account_archive}
\title{Retrieve LOBSTER data archive information}
\usage{
account_archive(account)
}
\arguments{
\item{account}{list Output from \code{\link[=account_login]{account_login()}} containing a valid
authenticated session (\code{valid == TRUE}).}
}
\value{
A tibble with one row per available dataset and columns:
\describe{
\item{id}{integer. Unique identifier for each dataset.}
\item{symbol}{character. Stock/ETF ticker symbol (e.g., \code{"SPY"}, \code{"AAPL"}).}
\item{start_date}{Date. First date of data coverage.}
\item{end_date}{Date. Last date of data coverage.}
\item{level}{integer. Order book depth (number of price levels).}
\item{size}{integer. File size in bytes.}
\item{download}{character. Direct download URL for the dataset.}
}
Rows are ordered by \code{id} descending (most recently requested first).
Datasets with zero file size (not yet processed by LOBSTER) are excluded.
}
\description{
Fetches information about available datasets in your LOBSTER account archive.
This includes details about symbols, date ranges, order book levels, file
sizes, and download links for each available dataset.
}
\details{
The function navigates to the archive page of the authenticated session,
scrapes the archive table, extracts download links, and returns a structured
tibble. Only datasets with non-zero file sizes are included — datasets still
being processed by LOBSTER will not appear until processing is complete.
}
\examples{
\dontrun{
acct <- account_login(
  login = Sys.getenv("LOBSTER_USER"),
  pwd   = Sys.getenv("LOBSTER_PWD")
)

archive <- account_archive(acct)
archive
#> # A tibble: 3 × 7
#>      id symbol start_date end_date   level    size download
#>   <int> <chr>  <date>     <date>     <int>   <int> <chr>
#> 1   102 AAPL   2023-01-03 2023-01-03     1  204800 https://…
#> 2   101 MSFT   2023-01-03 2023-01-05     2  512000 https://…
#> 3   100 SPY    2022-12-01 2022-12-31    10 1048576 https://…

# Filter to a single symbol before downloading
data_download(
  requested_data = archive[archive$symbol == "AAPL", ],
  account_login  = acct,
  path           = "data-lobster"
)
}

}
\seealso{
\code{\link[=account_login]{account_login()}}, \code{\link[=data_download]{data_download()}}
}
