% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcc}
\alias{mcc}
\title{MCC [p-value] [iid]}
\usage{
mcc(
  local_score,
  sequence_length,
  score_probabilities,
  sequence_min = NULL,
  sequence_max = NULL,
  score_values = NULL
)
}
\arguments{
\item{local_score}{the observed local score}

\item{sequence_length}{length of the sequence}

\item{score_probabilities}{the probabilities for each score from lowest to greatest (Optionnaly with scores as names)}

\item{sequence_min}{minimum score (optional if \code{score_values} OR names(score_probabilities) is defined)}

\item{sequence_max}{maximum score (optional if \code{score_values} OR names(score_probabilities) is defined)}

\item{score_values}{vector of integer score values, associated to score_probabilities  (optional if
\code{sequence_min} and \code{sequence_max} OR names(score_probabilities) are defined)}
}
\value{
A double representing the probability of a local score as high as the one given as argument
}
\description{
Calculates an approximated p-value for a given local score value and a medium to long sequence length in the identically and independently distributed model
}
\details{
This methods is actually an improved method of Karlin and produces more precise results. It should be privileged whenever possible. \cr
As with karlin, the method works the better the longer the sequence. Important note : the calculus of the parameter of the distribution uses
the resolution of a polynome which is a function of the score distribution, of order max(score)-min(score). There exists only empirical methods to solve a polynome of order greater that 5
with no warranty of reliable solution.
The found roots are checked internally to the function and an error message is throw in case of inconsistency. In such case, you could try to change your score scheme (in case of discretization)
or use the function \code{\link{karlinMonteCarlo}} .
}
\examples{
mcc(40, 100, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
mcc(40, 10000, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
mcc(150, 10000, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -5, 5)
p1 <- mcc(local_score = 15, sequence_length = 5000, 
       score_probabilities = c(0.2, 0.3, 0.1, 0.2, 0.1, 0.1), 
       sequence_min = -3, sequence_max = 2)
p2 <- mcc(local_score = 15, sequence_length = 5000, 
       score_probabilities = c(0.2, 0.3, 0.1, 0.2, 0.1, 0.1), 
       score_values = -3:2)
p1 == p2 # TRUE

prob <- c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02)
score_values <- which(prob != 0) - 6 # keep only non null probability scores
prob0 <- prob[prob != 0]             # and associated probability
p <- mcc(150, 10000, prob, sequence_min = -5, sequence_max =  5)
p0 <- mcc(150, 10000, prob0, score_values = score_values)
names(prob0) <- score_values
p1 <- mcc(150, 10000, prob0)
p == p0 # TRUE
p == p1 # TRUE
}
\seealso{
\code{\link{karlin}}, \code{\link{daudin}}, \code{\link{karlinMonteCarlo}}, \code{\link{monteCarlo}}
}
