% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec_locate.R
\name{exec_locate}
\alias{exec_locate}
\title{Find an executable}
\usage{
exec_locate(exec, cache = TRUE, dir = NULL, version = NULL)
}
\arguments{
\item{exec}{executable identifier, a single character.
Use one of these values:
\itemize{
\item \code{chrome}: 'Google Chrome' executable
\item \code{firefox}: 'Mozilla Firefox' executable
\item \code{libreoffice}: 'LibreOffice' executable
\item \code{node}: 'node.js' executable
\item \code{npm}: 'npm' executable
\item \code{python}: 'python' executable
\item \code{pip}: 'pip' executable
\item \code{excel}: 'Microsoft Excel' executable
\item \code{word}: 'Microsoft Word' executable
\item \code{powerpoint}: 'Microsoft PowerPoint' executable
}}

\item{cache}{if \code{FALSE}, search for the executable again even if the
executable has been found previously.}

\item{dir}{A character vector of directory paths under which
the executable may be found.}

\item{version}{The version of the executable to look for (e.g., \code{"14.15.4"}).
If NULL (the default), it searches for the highest version.}
}
\value{
A list containing the path of the executable and its version if found. If not found,
the version will be \code{0} and the \code{exec_file} will be \code{NULL}.
}
\description{
Searches for an executable in a some places and use the
highest version found (unless a specific version is requested).

The function mimic the behavior of the \code{rmarkdown::find_pandoc()}
function in order to locate programs.

Some methods work differently depending on the OS or the program:
\itemize{
\item Under Windows, the search
for 'Google Chrome', 'Mozilla Firefox', 'Microsoft Word', 'Microsoft PowerPoint'
and 'Microsoft Excel' is done in the registry, which means that only one version
can be chosen, the one referenced in the registry. (you still can force another path
with argument \code{dir}).
\item 'Microsoft Word', 'Microsoft PowerPoint' and 'Microsoft Excel' can not be located
on linux OS.
\item the search for 'pip' is using the result of the search of 'python' to find the corresponding
'pip' executable.
}
}
\section{libreoffice}{

On some Ubuntu platforms, 'LibreOffice' require to add in
the environment variable \code{LD_LIBRARY_PATH} the following path:
\verb{/usr/lib/libreoffice/program} (you should see the message
"libreglo.so cannot open shared object file" if it is the case). This
can be done with R
command \code{Sys.setenv(LD_LIBRARY_PATH = "/usr/lib/libreoffice/program/")}
}

\examples{
exec_locate("firefox")
exec_locate("chrome")
exec_locate("chrome", version = "88.0.4324.150")
exec_locate("libreoffice")
exec_locate("node")
exec_locate("npm")
exec_locate("python")
exec_locate("pip")
exec_locate("excel")
exec_locate("word")
exec_locate("powerpoint")
}
\seealso{
\code{\link[=exec_available]{exec_available()}} will check if an executable is available
and \code{\link[=exec_version]{exec_version()}} will return the version of a located executable.
}
