% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmi.R
\name{pool.clmi}
\alias{pool.clmi}
\title{Calculate pooled estimates from \code{clmi.out} objects using Rubin's rules}
\usage{
pool.clmi(formula, clmi.out, type)
}
\arguments{
\item{formula}{Formula to fit. Exposure variable should end in
\code{_transform_imputed}.}

\item{clmi.out}{An object generated by clmi.}

\item{type}{Type of regression to pool. Valid types are
logistic and linear.}
}
\description{
Calculate pooled estimates from \code{clmi.out} objects using Rubin's rules
}
\examples{
# continue example from clmi
# fit model on imputed data and pool results
library(lodi)
data("toy_data")
clmi.out <- clmi(log(poll) ~ case_cntrl + smoking + gender, toy_data, lod, 1)
results <- pool.clmi(case_cntrl ~ poll_transform_imputed + smoking, clmi.out,
                       logistic)

results$output
}
