% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design_experiment}
\alias{design_experiment}
\title{Helper function to generate code to run an experiment}
\usage{
design_experiment(
  levels_A = c(0, 1 * 2^(-4:2)),
  levels_B = c(0, 2 * 2^(-4:2)),
  par = c(beta_A = 1, beta_B = 2, gamma_A = 0.5, gamma_B = 0.5, tau_1 = 3, tau_2 = 0.05),
  n_rep = 1,
  n_sims = 100,
  noise_par = c(a0 = 3, a1 = 0.01)
)
}
\arguments{
\item{levels_A}{levels of A used in the combination}

\item{levels_B}{levels of B used in the combination}

\item{par}{named vector of model parameters}

\item{n_rep}{number of total repetitions of experiment}

\item{n_sims}{number of simulations to run}

\item{noise_par}{named vector with 'a0' and 'a1' which are used to generate noise for the GIA.}
}
\description{
Helper function to generate code to run an experiment
}
\details{
prints out code to copy and paste into \code{R} to simulate the expected coverage of your experiment under your designed hypothesis
}
