% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{plot.cv.lpca}
\alias{plot.cv.lpca}
\title{Plot CV for logistic PCA}
\usage{
\method{plot}{cv.lpca}(x, ...)
}
\arguments{
\item{x}{a \code{cv.lpca} object}

\item{...}{Additional arguments}
}
\description{
Plot cross validation results logistic PCA
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

\dontrun{
negloglikes = cv.lpca(dat, ks = 1:9, ms = 3:6)
plot(negloglikes)
}
}

