% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogngpdmix.R
\name{EMlogngpdmix}
\alias{EMlogngpdmix}
\title{Mixture estimation via EM}
\usage{
EMlogngpdmix(x0, y, maxiter, nboot = 0)
}
\arguments{
\item{x0}{numerical vector (5x1): initial values of the parameters p,
\eqn{\mu}, \eqn{\sigma}, \eqn{\xi}, \eqn{\beta}.}

\item{y}{vector: observed data.}

\item{maxiter}{positive integer: maximum number of iterations of the EM algorithm.}

\item{nboot}{positive integer: number of bootstrap replications for the
computation of the standard errors (defaults to 0).}
}
\value{
A list with the following elements is returned:
"p" = estimated value of p,
"post" = posterior probabilities of all observations,
"mu" = estimated value of \eqn{\mu},
"sigma " = estimated value of \eqn{\sigma},
"xi" = estimated value of \eqn{\xi},
"beta" = estimated value of \eqn{\beta},
"loglik" = maximimzed log-likelihood,
"nit" = number of iterations,
bootEst = matrix of parameter estimates at each bootstrap replications (only if nboot > 0).
bootStd = bootstrap standard errors of each parameter (only if nboot > 0).
}
\description{
This function estimates a static lognormal - generalized Pareto mixture
by means of the EM algorithm. Optionally, bootstrap standard errors are
computed via parallel computing.
}
\examples{
y <- rlognGPD(100,.9,0,1,0.5,2)
x0 <- c(.7,.2,1.3,.8,1.7)
res <- EMlogngpdmix(x0, y, 1000)

}
